/*
 * Decompiled with CFR 0.152.
 */
package codacy.git.runners;

import codacy.foundation.logging.Logger;
import codacy.foundation.logging.context.LogContext;
import codacy.git.runners.CommandError;
import codacy.git.runners.CommandExecutionContext;
import codacy.git.runners.ProcessResult;
import codacy.git.runners.TimeoutContext;
import com.typesafe.scalalogging.LazyLogging;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Try;

public final class CommandRunner$
implements Logger {
    public static final CommandRunner$ MODULE$ = new CommandRunner$();
    private static transient com.typesafe.scalalogging.Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private com.typesafe.scalalogging.Logger logger$lzycompute() {
        CommandRunner$ commandRunner$ = this;
        synchronized (commandRunner$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public com.typesafe.scalalogging.Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public Future<Seq<String>> runCommand(scala.collection.immutable.Seq<String> command, Duration timeout, ExecutionContext executionContext, LogContext logContext) {
        BoxedUnit boxedUnit;
        String commandLog = command.mkString("`", " ", "`");
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Executing command: {} with timeout: {}", new Object[]{commandLog, timeout});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        TimeoutContext timeoutContext = new TimeoutContext(timeout);
        CommandExecutionContext commandExecutionContext = new CommandExecutionContext(command, logContext);
        return Future$.MODULE$.firstCompletedOf((IterableOnce)new .colon.colon(commandExecutionContext.executionFuture(executionContext), (List)new .colon.colon(timeoutContext.timeoutFuture(), (List)Nil$.MODULE$)), executionContext).flatMap((Function1 & Serializable)x0$1 -> {
            ProcessResult processResult = x0$1;
            if (processResult != null) {
                int result = processResult.result();
                Seq<String> stdoutSeq = processResult.stdoutSeq();
                if (result == 0) {
                    return Future$.MODULE$.successful(stdoutSeq);
                }
            }
            if (processResult != null) {
                BoxedUnit boxedUnit;
                String errorOutput;
                int result = processResult.result();
                Seq<String> stderrSeq = processResult.stderrSeq();
                String string = errorOutput = stderrSeq.isEmpty() ? "None" : stderrSeq.mkString("\n");
                if (MODULE$.logger().underlying().isErrorEnabled()) {
                    MODULE$.logger().underlying().error("Command execution failed. Result: {}. Error output: {}", new Object[]{BoxesRunTime.boxToInteger((int)result), errorOutput});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return Future$.MODULE$.failed((Throwable)new CommandError(errorOutput));
            }
            throw new MatchError((Object)processResult);
        }, executionContext).andThen((PartialFunction)new Serializable(timeout, commandLog){
            private static final long serialVersionUID = 0L;
            private final Duration timeout$1;
            private final String commandLog$1;

            public final <A1 extends Try<Seq<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Failure failure;
                A1 A1 = x1;
                if (A1 instanceof Failure && (failure = (Failure)A1).exception() instanceof TimeoutException) {
                    if (CommandRunner$.MODULE$.logger().underlying().isErrorEnabled()) {
                        CommandRunner$.MODULE$.logger().underlying().error("Command execution timed out after {}. Command: {}", new Object[]{this.timeout$1, this.commandLog$1});
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Try<Seq<String>> x1) {
                Failure failure;
                Try<Seq<String>> try_ = x1;
                return try_ instanceof Failure && (failure = (Failure)try_).exception() instanceof TimeoutException;
            }
            {
                this.timeout$1 = timeout$1;
                this.commandLog$1 = commandLog$1;
            }
        }, executionContext).andThen((PartialFunction)new Serializable(commandExecutionContext){
            private static final long serialVersionUID = 0L;
            private final CommandExecutionContext commandExecutionContext$1;

            public final <A1 extends Try<Seq<String>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof Failure) {
                    this.commandExecutionContext$1.cleanup();
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Try<Seq<String>> x2) {
                Try<Seq<String>> try_ = x2;
                return try_ instanceof Failure;
            }
            {
                this.commandExecutionContext$1 = commandExecutionContext$1;
            }
        }, executionContext).andThen((PartialFunction)new Serializable(timeoutContext){
            private static final long serialVersionUID = 0L;
            private final TimeoutContext timeoutContext$1;

            public final <A1 extends Try<Seq<String>>, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                this.timeoutContext$1.cleanup();
                return (B1)BoxedUnit.UNIT;
            }

            public final boolean isDefinedAt(Try<Seq<String>> x3) {
                Try<Seq<String>> try_ = x3;
                return true;
            }
            {
                this.timeoutContext$1 = timeoutContext$1;
            }
        }, executionContext);
    }

    private CommandRunner$() {
    }
}

