/*
 * Decompiled with CFR 0.152.
 */
package codacy.git;

import codacy.foundation.logging.context.ContextAwareLogger;
import codacy.foundation.logging.context.ContextLogging;
import codacy.foundation.logging.context.LogContext;
import codacy.foundation.logging.context.ProjectLogContext;
import codacy.git.CommandWithParam;
import codacy.git.CommandWithParam$;
import codacy.git.GitCommandRunner;
import codacy.git.GitCommandRunner$FatalError$;
import codacy.git.GitCommandRunner$IndexLockError$;
import codacy.git.GitCommandRunner$UnadvertisedObjectRequest$;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.CodingErrorAction;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.io.FileUtils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.io.Codec;
import scala.io.Codec$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.sys.process.Process;
import scala.sys.process.Process$;
import scala.sys.process.ProcessIO;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class GitCommandRunner$
implements ContextLogging {
    public static final GitCommandRunner$ MODULE$;
    private static final Codec codacy$git$GitCommandRunner$$codec;
    private static transient ContextAwareLogger logger;
    private static volatile transient boolean bitmap$trans$0;

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        MODULE$ = new GitCommandRunner$();
        ContextLogging.$init$((ContextLogging)MODULE$);
        Codec codec0 = Codec$.MODULE$.UTF8();
        codec0.onMalformedInput(CodingErrorAction.IGNORE);
        codec0.onUnmappableCharacter(CodingErrorAction.IGNORE);
        codacy$git$GitCommandRunner$$codec = var0;
    }

    private ContextAwareLogger logger$lzycompute() {
        GitCommandRunner$ gitCommandRunner$ = this;
        synchronized (gitCommandRunner$) {
            if (!bitmap$trans$0) {
                logger = ContextLogging.logger$((ContextLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public ContextAwareLogger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public <T> T exec(CommandWithParam command, Option<File> directory, Option<Duration> timeout, T zero, Function2<T, String, T> fn, ProjectLogContext logContext) {
        return this.runBfs(command, directory, (Duration)timeout.getOrElse((Function0 & Serializable)() -> Duration$.MODULE$.Inf()), this.runBfs$default$4(), zero, fn, logContext);
    }

    public <T> T exec(scala.collection.immutable.Seq<String> command, Option<File> directory, Option<Duration> timeout, T zero, Function2<T, String, T> fn, ProjectLogContext logContext) {
        return this.runBfs(new CommandWithParam(command, CommandWithParam$.MODULE$.apply$default$2()), directory, (Duration)timeout.getOrElse((Function0 & Serializable)() -> Duration$.MODULE$.Inf()), this.runBfs$default$4(), zero, fn, logContext);
    }

    public <T> Option<File> exec$default$2() {
        return None$.MODULE$;
    }

    public <T> Option<Duration> exec$default$3() {
        return None$.MODULE$;
    }

    public void execNoOutput(CommandWithParam command, Option<File> directory, Option<Duration> timeout, ProjectLogContext logContext) {
        this.runBfs(command, directory, (Duration)timeout.getOrElse((Function0 & Serializable)() -> Duration$.MODULE$.Inf()), this.runBfs$default$4(), BoxedUnit.UNIT, (Function2 & Serializable)(x$1, x$2) -> {
            GitCommandRunner$.$anonfun$execNoOutput$2(x$1, x$2);
            return BoxedUnit.UNIT;
        }, logContext);
    }

    public Option<File> execNoOutput$default$2() {
        return None$.MODULE$;
    }

    public Option<Duration> execNoOutput$default$3() {
        return None$.MODULE$;
    }

    public Codec codacy$git$GitCommandRunner$$codec() {
        return codacy$git$GitCommandRunner$$codec;
    }

    private Timer triggerTimeout(Process process, Duration timeout, ProjectLogContext logContext) {
        Timer timer;
        block0: {
            timer = new Timer();
            Duration duration = timeout;
            Duration.Infinite infinite = Duration$.MODULE$.Inf();
            if (!(duration == null ? infinite != null : !duration.equals(infinite))) break block0;
            timer.schedule(new TimerTask(process, logContext){
                private final Process process$1;
                private final ProjectLogContext logContext$1;

                public void run() {
                    Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                        $this.process$1.destroy();
                        GitCommandRunner$.MODULE$.codacy$git$GitCommandRunner$$cleanupHangingProcesses((scala.collection.immutable.Seq<String>)new .colon.colon((Object)"ssh-add", (List)new .colon.colon((Object)"git", (List)Nil$.MODULE$)), $this.logContext$1);
                    });
                }
                {
                    this.process$1 = process$1;
                    this.logContext$1 = logContext$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(codacy.git.GitCommandRunner$$anon$1 )}, serializedLambda);
                }
            }, timeout.toMillis());
        }
        return timer;
    }

    private Option<GitCommandRunner.Error> parseStdErr(String line) {
        if (line.contains("index.lock")) {
            return new Some((Object)GitCommandRunner$IndexLockError$.MODULE$);
        }
        if (line.contains("fatal: Invalid symmetric difference expression")) {
            return new Some((Object)GitCommandRunner$FatalError$.MODULE$);
        }
        if (line.contains("Server does not allow request for unadvertised object")) {
            return new Some((Object)GitCommandRunner$UnadvertisedObjectRequest$.MODULE$);
        }
        return None$.MODULE$;
    }

    private <T> T runBfs(CommandWithParam commandWithParam, Option<File> dir, Duration timeout, int retries, T zero, Function2<T, String, T> fn, ProjectLogContext logContext) {
        int result;
        ObjectRef commandErrorText;
        String dirLog;
        String commandLog;
        while (true) {
            boolean bl;
            commandLog = commandWithParam.command().mkString("`", " ", "`");
            dirLog = (String)dir.map((Function1 & Serializable)x$3 -> x$3.getPath()).getOrElse((Function0 & Serializable)() -> "N/A");
            this.logger().info(new StringBuilder(52).append("Executing git command: ").append(commandLog).append(", pwd: ").append(dirLog).append(", timeout: ").append(timeout).append(", retries: ").append(retries).toString(), (LogContext)logContext);
            ObjectRef commandResult = ObjectRef.create(zero);
            commandErrorText = ObjectRef.create((Object)((scala.collection.immutable.Seq)Nil$.MODULE$));
            ObjectRef userCodeThrowable = ObjectRef.create((Object)Option$.MODULE$.empty());
            ProcessIO pio = new ProcessIO((Function1 & Serializable)writeInput -> {
                writeInput.close();
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)stdout -> {
                GitCommandRunner$.$anonfun$runBfs$4(commandResult, zero, fn, userCodeThrowable, stdout);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)stderr -> {
                GitCommandRunner$.$anonfun$runBfs$5(commandErrorText, stderr);
                return BoxedUnit.UNIT;
            });
            Process process = Process$.MODULE$.apply(commandWithParam.fillTokenPart(), dir, (scala.collection.immutable.Seq)Nil$.MODULE$).run(pio);
            Timer timeoutTimer = this.triggerTimeout(process, timeout, logContext);
            result = process.exitValue();
            ((Option)userCodeThrowable.elem).foreach((Function1 & Serializable)x$4 -> {
                throw x$4;
            });
            timeoutTimer.cancel();
            if (result == 0) {
                return (T)commandResult.elem;
            }
            this.logger().warn(new StringBuilder(33).append("Command failed: ").append(commandLog).append(", pwd: ").append(dirLog).append(", result: ").append(result).toString(), (LogContext)logContext);
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                process.destroy();
                MODULE$.codacy$git$GitCommandRunner$$cleanupHangingProcesses((scala.collection.immutable.Seq<String>)new .colon.colon((Object)"ssh-add", (List)new .colon.colon((Object)"git", (List)Nil$.MODULE$)), logContext);
            });
            scala.collection.immutable.Seq commandErrors = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)commandErrorText.elem).flatMap((Function1 & Serializable)line -> MODULE$.parseStdErr((String)line));
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = bl = retries > 0;
            if (bl) {
                bl2 = true;
                bl3 = bl;
                if (commandErrors.contains((Object)GitCommandRunner$IndexLockError$.MODULE$)) {
                    this.logger().warn(new StringBuilder(86).append("IndexLockError error while executing command: ").append(commandLog).append(", pwd: ").append(dirLog).append(". ").append("Delete the lock file and retry.").toString(), (LogContext)logContext);
                    Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> FileUtils.forceDelete((File)new File(new StringBuilder(4).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)dir), File.separator)).append(".git").toString(), "index.lock")));
                    --retries;
                    continue;
                }
            }
            if (bl2 && commandErrors.contains((Object)GitCommandRunner$FatalError$.MODULE$)) {
                this.logger().warn(new StringBuilder(80).append("Fatal error while executing command: ").append(commandLog).append(", pwd: ").append(dirLog).append(". ").append("Run a recovery command and repeat.").toString(), (LogContext)logContext);
                CommandWithParam recoveryCmd = new CommandWithParam((scala.collection.immutable.Seq<String>)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"clean", (List)new .colon.colon((Object)"-dfx", (List)Nil$.MODULE$))), CommandWithParam$.MODULE$.apply$default$2());
                this.runBfs(recoveryCmd, dir, timeout, 0, BoxedUnit.UNIT, (Function2 & Serializable)(x$5, x$6) -> {
                    GitCommandRunner$.$anonfun$runBfs$10(x$5, x$6);
                    return BoxedUnit.UNIT;
                }, logContext);
                --retries;
                continue;
            }
            if (!bl2 || !commandErrors.contains((Object)GitCommandRunner$UnadvertisedObjectRequest$.MODULE$)) break;
            this.logger().warn(new StringBuilder(72).append("UnadvertisedObjectRequest error while executing command: ").append(commandLog).append(", pwd: ").append(dirLog).append(". Retry.").toString(), (LogContext)logContext);
            --retries;
        }
        String commandError = ((scala.collection.immutable.Seq)commandErrorText.elem).mkString("\n");
        String errorStr = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(117).append("Error running git command: ").append(commandLog).append("\n               | pwd: ").append(dirLog).append("\n               | result: ").append(result).append("\n               | command error message: ").append(commandError).toString()));
        this.logger().error(errorStr, (LogContext)logContext);
        throw new Exception(errorStr);
    }

    private <T> int runBfs$default$4() {
        return 1;
    }

    public void codacy$git$GitCommandRunner$$cleanupHangingProcesses(scala.collection.immutable.Seq<String> cmdNames, ProjectLogContext logContext) {
        this.logger().info(new StringBuilder(41).append("Cleaning up possibly hanging processes (").append(cmdNames.mkString(",")).append(")").toString(), (LogContext)logContext);
        cmdNames.foreach((Function1 & Serializable)cmdName -> BoxesRunTime.boxToInteger((int)GitCommandRunner$.$anonfun$cleanupHangingProcesses$1(cmdName)));
    }

    public static final /* synthetic */ void $anonfun$execNoOutput$2(BoxedUnit x$1, String x$2) {
    }

    public static final /* synthetic */ void $anonfun$runBfs$4(ObjectRef commandResult$1, Object zero$1, Function2 fn$1, ObjectRef userCodeThrowable$1, InputStream stdout) {
        block6: {
            GitCommandRunner.OnlyNewLineBufferedSource buffSource = new GitCommandRunner.OnlyNewLineBufferedSource(stdout);
            try {
                try {
                    commandResult$1.elem = buffSource.getLines().foldLeft(zero$1, fn$1);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        userCodeThrowable$1.elem = new Some((Object)e);
                        break block6;
                    }
                    throw throwable;
                }
            }
            finally {
                stdout.close();
            }
        }
    }

    public static final /* synthetic */ void $anonfun$runBfs$5(ObjectRef commandErrorText$1, InputStream stderr) {
        GitCommandRunner.OnlyNewLineBufferedSource buffSource = new GitCommandRunner.OnlyNewLineBufferedSource(stderr);
        commandErrorText$1.elem = buffSource.getLines().toList();
        stderr.close();
    }

    public static final /* synthetic */ void $anonfun$runBfs$10(BoxedUnit x$5, String x$6) {
    }

    public static final /* synthetic */ int $anonfun$cleanupHangingProcesses$1(String cmdName) {
        return Process$.MODULE$.apply((Seq)new .colon.colon((Object)"pkill", (List)new .colon.colon((Object)"-KILL", (List)new .colon.colon((Object)cmdName, (List)Nil$.MODULE$)))).$bang();
    }

    private GitCommandRunner$() {
    }
}

