/*
 * Decompiled with CFR 0.152.
 */
package codacy.git.repository;

import codacy.foundation.logging.context.ContextAwareLogger;
import codacy.foundation.logging.context.ContextLogging;
import codacy.foundation.logging.context.LogContext;
import codacy.git.repository.GitBranch;
import codacy.git.repository.GitBranch$;
import codacy.git.repository.GitPullRequest;
import codacy.git.repository.ReadOnlyGitRepository;
import java.io.Serializable;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.util.matching.Regex;

public final class ReadOnlyGitRepository$
implements ContextLogging {
    public static final ReadOnlyGitRepository$ MODULE$ = new ReadOnlyGitRepository$();
    private static final String prPrefix;
    private static final String MainPattern;
    private static final String DefaultRefsPattern;
    private static final String codacy$git$repository$ReadOnlyGitRepository$$GitHubPullRequestRefsPattern;
    private static final Regex MainBranchName;
    private static final Regex MainBranchUUID;
    private static final Regex Branch;
    private static final Regex GitHubPullRequest;
    private static final Regex InvalidBranch;
    private static transient ContextAwareLogger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        ContextLogging.$init$((ContextLogging)MODULE$);
        prPrefix = "codacy-amN6znLRueK4Yky";
        MainPattern = "HEAD";
        DefaultRefsPattern = "refs/heads/*";
        codacy$git$repository$ReadOnlyGitRepository$$GitHubPullRequestRefsPattern = "refs/pull/*/head";
        MainBranchName = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^ref: refs/heads/(.*)[\\t]+HEAD$"));
        MainBranchUUID = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([a-z0-9]+)[ \\t]+HEAD$"));
        Branch = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([a-z0-9]+)[ \\t]+refs/heads/(.*)$"));
        GitHubPullRequest = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([a-z0-9]+)[ \\t]+refs/pull/([0-9]+)/head$"));
        InvalidBranch = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([a-z0-9]+)[ \\t]+refs/heads/(?:HEAD|refs/heads/.*)$"));
    }

    private ContextAwareLogger logger$lzycompute() {
        ReadOnlyGitRepository$ readOnlyGitRepository$ = this;
        synchronized (readOnlyGitRepository$) {
            if (!bitmap$trans$0) {
                logger = ContextLogging.logger$((ContextLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public ContextAwareLogger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public String prPrefix() {
        return prPrefix;
    }

    public String MainPattern() {
        return MainPattern;
    }

    public String DefaultRefsPattern() {
        return DefaultRefsPattern;
    }

    public String codacy$git$repository$ReadOnlyGitRepository$$GitHubPullRequestRefsPattern() {
        return codacy$git$repository$ReadOnlyGitRepository$$GitHubPullRequestRefsPattern;
    }

    private Regex MainBranchName() {
        return MainBranchName;
    }

    private Regex MainBranchUUID() {
        return MainBranchUUID;
    }

    private Regex Branch() {
        return Branch;
    }

    private Regex GitHubPullRequest() {
        return GitHubPullRequest;
    }

    private Regex InvalidBranch() {
        return InvalidBranch;
    }

    public String codacy$git$repository$ReadOnlyGitRepository$$toBranchRef(String branchName) {
        return new StringBuilder(11).append("refs/heads/").append(branchName).toString();
    }

    public String codacy$git$repository$ReadOnlyGitRepository$$toGitHubPullRequestRef(long prNumber) {
        return new StringBuilder(15).append("refs/pull/").append(prNumber).append("/head").toString();
    }

    public ReadOnlyGitRepository.ParsedRefState parseRef(ReadOnlyGitRepository.ParsedRefState state, String line, LogContext logContext) {
        Option option;
        Option option2;
        Option option3;
        Option option4;
        Option option5;
        String string = line;
        if (string != null && !(option5 = this.InvalidBranch().unapplySeq((CharSequence)string)).isEmpty() && option5.get() != null && ((List)option5.get()).lengthCompare(1) == 0) {
            String latestCommitUUID = (String)((LinearSeqOps)option5.get()).apply(0);
            this.logger().warn(new StringBuilder(56).append("Failed to insert branch with commit UUID ").append(latestCommitUUID).append(".").append("Invalid line: ").append(line).toString(), logContext);
            return state;
        }
        if (string != null && !(option4 = this.Branch().unapplySeq((CharSequence)string)).isEmpty() && option4.get() != null && ((List)option4.get()).lengthCompare(2) == 0) {
            String latestCommitUUID = (String)((LinearSeqOps)option4.get()).apply(0);
            String name = (String)((LinearSeqOps)option4.get()).apply(1);
            state.branchesMapBuilder().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)new GitBranch(name, latestCommitUUID, GitBranch$.MODULE$.apply$default$3())));
            return state;
        }
        if (string != null && !(option3 = this.GitHubPullRequest().unapplySeq((CharSequence)string)).isEmpty() && option3.get() != null && ((List)option3.get()).lengthCompare(2) == 0) {
            String latestCommitUUID = (String)((LinearSeqOps)option3.get()).apply(0);
            String number = (String)((LinearSeqOps)option3.get()).apply(1);
            String name = new StringBuilder(4).append(this.prPrefix()).append("/pr/").append(number).toString();
            state.pullRequestsMapBuilder().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)new GitPullRequest(name, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(number)), latestCommitUUID)));
            return state;
        }
        if (string != null && !(option2 = this.MainBranchUUID().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(1) == 0) {
            String latestCommitUUID = (String)((LinearSeqOps)option2.get()).apply(0);
            return state.copy((Option<String>)Option$.MODULE$.apply((Object)latestCommitUUID), state.copy$default$2(), state.copy$default$3(), state.copy$default$4());
        }
        if (string != null && !(option = this.MainBranchName().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String name = (String)((LinearSeqOps)option.get()).apply(0);
            Option x$1 = Option$.MODULE$.apply((Object)name);
            Option<String> x$2 = state.copy$default$1();
            Builder<Tuple2<String, GitBranch>, Map<String, GitBranch>> x$3 = state.copy$default$3();
            Builder<Tuple2<String, GitPullRequest>, Map<String, GitPullRequest>> x$4 = state.copy$default$4();
            return state.copy(x$2, (Option<String>)x$1, x$3, x$4);
        }
        return state;
    }

    public Seq<GitBranch> codacy$git$repository$ReadOnlyGitRepository$$toSeqWithMain(Map<String, GitBranch> allBranches, String mainBranchUUID, String mainBranchName) {
        GitBranch mainBranch = new GitBranch(mainBranchName, mainBranchUUID, true);
        return (Seq)allBranches.foldRight((Object)new .colon.colon((Object)mainBranch, (List)Nil$.MODULE$), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Seq acc = (Seq)tuple2._2();
                if (tuple22 != null) {
                    String name = (String)tuple22._1();
                    GitBranch branch = (GitBranch)tuple22._2();
                    String string = name;
                    String string2 = mainBranchName;
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        GitBranch gitBranch = branch;
                        return (Seq)acc.$plus$colon((Object)gitBranch);
                    }
                    return acc;
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private ReadOnlyGitRepository$() {
    }
}

