/*
 * Decompiled with CFR 0.152.
 */
package codacy.git.repository;

import codacy.foundation.crypto.CryptoTools$;
import codacy.foundation.logging.context.LogContext;
import codacy.foundation.logging.context.ProjectLogContext;
import codacy.git.CommandWithParam;
import codacy.git.CommandWithParam$;
import codacy.git.GitCommandRunner$;
import codacy.git.diff.CommitDiff;
import codacy.git.repository.AccessTokenInUrl;
import codacy.git.repository.AccessTokenRepositoryData;
import codacy.git.repository.BranchRequest;
import codacy.git.repository.CommitRequest;
import codacy.git.repository.GitCommit;
import codacy.git.repository.GitCommitWithIndex;
import codacy.git.repository.GitFile;
import codacy.git.repository.GitFileContents;
import codacy.git.repository.GitFileContents$;
import codacy.git.repository.GitListResult;
import codacy.git.repository.GitListResult$;
import codacy.git.repository.GitRepository;
import codacy.git.repository.ProjectRequest;
import codacy.git.repository.RepositoryData;
import codacy.git.repository.WriteGitRepository$;
import codacy.utils.FileOperations$;
import codacy.utils.FileSystemLocks;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u0011ue!\u0002'N\u0003\u0003!\u0006\u0002C0\u0001\u0005\u000b\u0007I\u0011\u00011\t\u00119\u0004!\u0011!Q\u0001\n\u0005D\u0001b\u001c\u0001\u0003\u0006\u0004%\t\u0001\u0019\u0005\ta\u0002\u0011\t\u0011)A\u0005C\"A\u0011\u000f\u0001B\u0001B\u0003-!\u000fC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0004\u0000\u0001\u0011EQ*!\u0001\t\u000f\u0005\u0005\u0002\u0001\"\u0005NA\"A\u00111\u0005\u0001\u0007\u0012=\u000b)\u0003\u0003\u0006\u0002\u0004\u0002\t\n\u0011\"\u0005P\u0003\u000bCq!a(\u0001\r\u0003\t\t\u000bC\u0004\u00022\u0002!\t\"a-\t\u000f\u0005E\u0006\u0001\"\u0005\u0002X\"9\u0011q\u001d\u0001\u0005\n\u0005%\bbBA|\u0001\u0011\u0005\u0011\u0011 \u0005\b\u0005\u001b\u0001A\u0011\u0001B\b\u0011%\u0011I\u0004AI\u0001\n\u0003\u0011Y\u0004C\u0004\u0003\u000e\u0001!\tAa\u0010\t\u000f\t5\u0001\u0001\"\u0001\u0003T!9!\u0011\r\u0001\u0005\u0002\t\r\u0004b\u0002B;\u0001\u0011\u0005!q\u000f\u0005\b\u0005\u0003\u0003A\u0011\u0002BB\u0011!\u0011Y\t\u0001C\u0001\u001f\n5\u0005b\u0002BJ\u0001\u0011\u0005!Q\u0013\u0005\b\u0005W\u0003A\u0011\u0003BW\u0011\u001d\u0011Y\f\u0001C\u0005\u0005{CqAa3\u0001\t\u0003\u0011i\rC\u0005\u0003d\u0002\t\n\u0011\"\u0001\u0003<!9!Q\u001d\u0001\u0005\u0002\t\u001d\bb\u0002B\u007f\u0001\u0011\u0005!q \u0005\b\u0007K\u0001A\u0011AB\u0014\u0011\u001d\u0019)\u0004\u0001C\u0001\u0007oAqaa\u0013\u0001\t\u0003\u0019i\u0005C\u0004\u0004V\u0001!Iaa\u0016\t\u000f\r\u0015\u0004\u0001\"\u0003\u0004h!91Q\u000b\u0001\u0005\n\rE\u0004bBBA\u0001\u0011%11\u0011\u0005\b\u0005C\u0002A\u0011BBL\u000f\u001d\u0019\u0019+\u0014E\u0001\u0007K3a\u0001T'\t\u0002\r\u001d\u0006B\u0002=)\t\u0003\u0019)\fC\u0005\u00048\"\u0012\r\u0011\"\u0001\u0004:\"A1Q\u0019\u0015!\u0002\u0013\u0019Y\fC\u0005\u0004H\"\u0012\r\u0011\"\u0001\u0004:\"A1\u0011\u001a\u0015!\u0002\u0013\u0019Y\fC\u0005\u0004L\"\u0012\r\u0011\"\u0001\u0004:\"A1Q\u001a\u0015!\u0002\u0013\u0019Y\fC\u0005\u0004P\"\u0012\r\u0011\"\u0001\u0004:\"A1\u0011\u001b\u0015!\u0002\u0013\u0019Y\fC\u0005\u0004T\"\u0012\r\u0011\"\u0003\u0004V\"A1q\u001d\u0015!\u0002\u0013\u00199\u000eC\u0005\u0004j\"\u0012\r\u0011\"\u0003\u0004l\"A1q\u001f\u0015!\u0002\u0013\u0019i\u000fC\u0005\u0004z\"\u0012\r\u0011\"\u0003\u0004l\"A11 \u0015!\u0002\u0013\u0019i\u000f\u0003\u0006\u0004~\"B)\u0019!C\u0005\u0007WDqaa@)\t\u0013!\t\u0001C\u0006\u0005\n!B)\u0019!C\u0001\u001f\u000eU\u0007\u0002\u0003C\u0006Q\u0011\u0005q\n\"\u0004\t\u0011\u0011M\u0001\u0006\"\u0001P\t+Aq\u0001\"\u0007)\t\u0013!Y\u0002C\u0004\u0005$!\"I\u0001\"\n\t\u000f\u00115\u0002\u0006\"\u0005\u00050!AAq\b\u0015\u0005\u0002=#\t\u0005\u0003\u0006\u0005R!\n\n\u0011\"\u0001P\t'B\u0001Ba%)\t\u0003yEq\u000b\u0005\t\t?BC\u0011A(\u0005b!IAQ\u000e\u0015C\u0002\u0013\u00151Q\u001b\u0005\t\t_B\u0003\u0015!\u0004\u0004X\"IA\u0011\u000f\u0015C\u0002\u0013\u00151Q\u001b\u0005\t\tgB\u0003\u0015!\u0004\u0004X\"AAQ\u000f\u0015\u0005\u0002=#9\bC\u0005\u0005\n\"\u0012\r\u0011\"\u0003\u0005\f\"AAQ\u0012\u0015!\u0002\u0013\u0011\u0019\u0004C\u0004\u0005\u0010\"\"I\u0001\"%\u0003%]\u0013\u0018\u000e^3HSR\u0014V\r]8tSR|'/\u001f\u0006\u0003\u001d>\u000b!B]3q_NLGo\u001c:z\u0015\t\u0001\u0016+A\u0002hSRT\u0011AU\u0001\u0007G>$\u0017mY=\u0004\u0001M\u0019\u0001!V-\u0011\u0005Y;V\"A'\n\u0005ak%!D$jiJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002[;6\t1L\u0003\u0002]#\u0006)Q\u000f^5mg&\u0011al\u0017\u0002\u0010\r&dWmU=ti\u0016lGj\\2lg\u00061\"/\u001a9pg&$xN]=LKf\u001cHj\\2bi&|g.F\u0001b!\t\u00117N\u0004\u0002dSB\u0011AmZ\u0007\u0002K*\u0011amU\u0001\u0007yI|w\u000e\u001e \u000b\u0003!\fQa]2bY\u0006L!A[4\u0002\rA\u0013X\rZ3g\u0013\taWN\u0001\u0004TiJLgn\u001a\u0006\u0003U\u001e\fqC]3q_NLGo\u001c:z\u0017\u0016L8\u000fT8dCRLwN\u001c\u0011\u0002%I,\u0007o\\:ji>\u0014\u0018\u0010T8dCRLwN\\\u0001\u0014e\u0016\u0004xn]5u_JLHj\\2bi&|g\u000eI\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\"a\u001d<\u000e\u0003QT!!^4\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002xi\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007ilh\u0010\u0006\u0002|yB\u0011a\u000b\u0001\u0005\u0006c\u001a\u0001\u001dA\u001d\u0005\u0006?\u001a\u0001\r!\u0019\u0005\u0006_\u001a\u0001\r!Y\u0001\rG2|g.Z(qi&|gn\u001d\u000b\u0005\u0003\u0007\t)\u0002E\u0003\u0002\u0006\u0005=\u0011M\u0004\u0003\u0002\b\u0005-ab\u00013\u0002\n%\t\u0001.C\u0002\u0002\u000e\u001d\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0012\u0005M!aA*fc*\u0019\u0011QB4\t\u000f\u0005]q\u00011\u0001\u0002\u001a\u0005I!/Z2veNLg/\u001a\t\u0005\u00037\ti\"D\u0001h\u0013\r\tyb\u001a\u0002\b\u0005>|G.Z1o\u0003)\u0001\u0018\r\u001e5Qe\u00164\u0017\u000e_\u0001\u000fo&$\bNU3q_NLGo\u001c:z+\u0011\t9#!\r\u0015\r\u0005%\u0012QOA@)\u0011\tY#a\u0017\u0015\t\u00055\u00121\t\t\u0005\u0003_\t\t\u0004\u0004\u0001\u0005\u000f\u0005M\u0012B1\u0001\u00026\t\tA+\u0005\u0003\u00028\u0005u\u0002\u0003BA\u000e\u0003sI1!a\u000fh\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a\u0007\u0002@%\u0019\u0011\u0011I4\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002F%\u0001\u001d!a\u0012\u0002\u00151|wmQ8oi\u0016DH\u000f\u0005\u0003\u0002J\u0005]SBAA&\u0015\u0011\ti%a\u0014\u0002\u000f\r|g\u000e^3yi*!\u0011\u0011KA*\u0003\u001dawnZ4j]\u001eT1!!\u0016R\u0003)1w.\u001e8eCRLwN\\\u0005\u0005\u00033\nYEA\tQe>TWm\u0019;M_\u001e\u001cuN\u001c;fqRDq!!\u0018\n\u0001\u0004\ty&A\u0003cY>\u001c7\u000e\u0005\u0005\u0002\u001c\u0005\u0005\u0014QMA\u0017\u0013\r\t\u0019g\u001a\u0002\n\rVt7\r^5p]F\u0002B!a\u001a\u0002r5\u0011\u0011\u0011\u000e\u0006\u0005\u0003W\ni'\u0001\u0002j_*\u0011\u0011qN\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002t\u0005%$\u0001\u0002$jY\u0016Dq!a\u001e\n\u0001\u0004\tI(A\u0004qe>TWm\u0019;\u0011\u0007Y\u000bY(C\u0002\u0002~5\u0013a\u0002\u0015:pU\u0016\u001cGOU3rk\u0016\u001cH\u000fC\u0005\u0002\u0002&\u0001\n\u00111\u0001\u0002\u001a\u0005Yam\u001c:dKV\u0003H-\u0019;f\u0003a9\u0018\u000e\u001e5SKB|7/\u001b;pef$C-\u001a4bk2$HEM\u000b\u0005\u0003\u000f\u000bi*\u0006\u0002\u0002\n*\"\u0011\u0011DAFW\t\ti\t\u0005\u0003\u0002\u0010\u0006eUBAAI\u0015\u0011\t\u0019*!&\u0002\u0013Ut7\r[3dW\u0016$'bAALO\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0015\u0011\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GaBA\u001a\u0015\t\u0007\u0011QG\u0001\u0011kB$\u0017\r^3SKB|7/\u001b;pef$B!a)\u0002.R!\u0011QUAV!\u0011\tY\"a*\n\u0007\u0005%vM\u0001\u0003V]&$\bbBA#\u0017\u0001\u000f\u0011q\t\u0005\b\u0003_[\u0001\u0019AA=\u00039\u0001(o\u001c6fGR\u0014V-];fgR\f!\u0003];mY\u000eC\u0017M\\4fg>\u00138\t\\8oKRA\u0011QWAf\u0003\u001f\f\u0019\u000e\u0006\u0004\u0002&\u0006]\u0016\u0011\u001a\u0005\b\u0003sc\u00019AA^\u0003\u0005a\u0007\u0003BA_\u0003\u0007t1AWA`\u0013\r\t\tmW\u0001\u0010\r&dWmU=ti\u0016lGj\\2lg&!\u0011QYAd\u0005\u0011aunY6\u000b\u0007\u0005\u00057\fC\u0004\u0002F1\u0001\u001d!a\u0012\t\u000f\u00055G\u00021\u0001\u0002z\u0005Q\u0001O]8kK\u000e$(+Z9\t\u000f\u0005EG\u00021\u0001\u0002f\u0005Q\u0001O]8kK\u000e$H)\u001b:\t\u000f\u0005UG\u00021\u0001\u0002\u001a\u0005y1\r\\8oKN+(-\\8ek2,7\u000f\u0006\u0006\u0002Z\u0006}\u0017\u0011]Ar\u0003K$b!!\u001a\u0002\\\u0006u\u0007bBA]\u001b\u0001\u000f\u00111\u0018\u0005\b\u0003\u000bj\u00019AA$\u0011\u001d\t9(\u0004a\u0001\u0003sBq!!5\u000e\u0001\u0004\t)\u0007C\u0004\u0002\u00026\u0001\r!!\u0007\t\u000f\u0005UW\u00021\u0001\u0002\u001a\u0005i1\r\\3b]\u0006sGm\u00117p]\u0016$\u0002\"a;\u0002r\u0006M\u0018Q\u001f\u000b\u0007\u0003K\u000bi/a<\t\u000f\u0005ef\u0002q\u0001\u0002<\"9\u0011Q\t\bA\u0004\u0005\u001d\u0003bBAg\u001d\u0001\u0007\u0011\u0011\u0010\u0005\b\u0003#t\u0001\u0019AA3\u0011\u001d\t)N\u0004a\u0001\u00033\tQbZ3u\u00032d7i\\7nSR\u001cH\u0003BA~\u0005\u0017!B!!@\u0003\nA1\u0011QAA\u0000\u0005\u0007IAA!\u0001\u0002\u0014\t!A*[:u!\r1&QA\u0005\u0004\u0005\u000fi%AE$ji\u000e{W.\\5u/&$\b.\u00138eKbDq!!\u0012\u0010\u0001\b\t9\u0005C\u0004\u0002x=\u0001\r!!\u001f\u0002!\u001d,GO\u0011:b]\u000eD7i\\7nSR\u001cH\u0003\u0003B\t\u0005;\u0011yB!\u000b\u0015\t\tM!1\u0004\t\u0007\u0003\u000b\tyP!\u0006\u0011\u0007Y\u00139\"C\u0002\u0003\u001a5\u0013\u0011bR5u\u0007>lW.\u001b;\t\u000f\u0005\u0015\u0003\u0003q\u0001\u0002H!9\u0011q\u000f\tA\u0002\u0005e\u0004b\u0002B\u0011!\u0001\u0007!1E\u0001\u0007EJ\fgn\u00195\u0011\u0007Y\u0013)#C\u0002\u0003(5\u0013QB\u0011:b]\u000eD'+Z9vKN$\b\"\u0003B\u0016!A\u0005\t\u0019\u0001B\u0017\u0003\u0015a\u0017.\\5u!\u0019\tYBa\f\u00034%\u0019!\u0011G4\u0003\r=\u0003H/[8o!\u0011\tYB!\u000e\n\u0007\t]rMA\u0002J]R\f!dZ3u\u0005J\fgn\u00195D_6l\u0017\u000e^:%I\u00164\u0017-\u001e7uIM*\"A!\u0010+\t\t5\u00121\u0012\u000b\t\u0005\u0003\u0012iEa\u0014\u0003RQ!!1\tB&!\u0019\t)!a@\u0003FA\u0019aKa\u0012\n\u0007\t%SJA\u0007D_6l\u0017\u000e\u001e*fcV,7\u000f\u001e\u0005\b\u0003\u000b\u0012\u00029AA$\u0011\u001d\t9H\u0005a\u0001\u0003sBqA!\t\u0013\u0001\u0004\u0011\u0019\u0003C\u0004\u0003,I\u0001\rA!\u0012\u0015\r\tU#\u0011\fB.)\u0011\u0011\u0019Ba\u0016\t\u000f\u0005\u00153\u0003q\u0001\u0002H!9\u0011qO\nA\u0002\u0005e\u0004b\u0002B/'\u0001\u0007!qL\u0001\tEJ\fgn\u00195fgB1\u0011QAA\b\u0005G\t!CZ5oI\u000e{W.\\8o\u0003:\u001cWm\u001d;peRA!Q\rB6\u0005[\u0012\t\b\u0006\u0003\u0003h\t%\u0004CBA\u000e\u0005_\u0011)\u0005C\u0004\u0002FQ\u0001\u001d!a\u0012\t\u000f\u0005]D\u00031\u0001\u0002z!9!q\u000e\u000bA\u0002\t\r\u0012AB:pkJ\u001cW\rC\u0004\u0003tQ\u0001\rAa\t\u0002\u0017\u0011,7\u000f^5oCRLwN\\\u0001\u0010G2,\u0017M\u001c)s_*,7\r\u001e#jeR!!\u0011\u0010B?)\u0011\t)Ka\u001f\t\u000f\u0005\u0015S\u0003q\u0001\u0002H!1!qP\u000bA\u0002\u0005\f!\u0002\u001d:pU\u0016\u001cG/\u0016:m\u0003I\u0011Xm\u0019:fCR,\u0007K]8kK\u000e$H)\u001b:\u0015\t\t\u0015%\u0011\u0012\u000b\u0005\u0003K\u00139\tC\u0004\u0002FY\u0001\u001d!a\u0012\t\u000f\u0005Eg\u00031\u0001\u0002f\u0005qq-\u001a;Qe>TWm\u0019;QCRDG\u0003BA3\u0005\u001fCaA!%\u0018\u0001\u0004\t\u0017\u0001B5ve2\f1cZ3oKJ\fG/\u001a)s_*,7\r\u001e#bi\u0006$BAa&\u0003\"R!!\u0011\u0014BP!\r1&1T\u0005\u0004\u0005;k%A\u0004*fa>\u001c\u0018\u000e^8ss\u0012\u000bG/\u0019\u0005\b\u0003\u000bB\u00029AA$\u0011\u001d\u0011\u0019\u000b\u0007a\u0001\u0005K\u000baA^1mk\u0016\u001c\b#\u00022\u0003(\u0006\f\u0017b\u0001BU[\n\u0019Q*\u00199\u0002\u0017A,H\u000e\\\"iC:<Wm\u001d\u000b\u0007\u0005_\u0013\u0019La.\u0015\t\u0005\u0015&\u0011\u0017\u0005\b\u0003\u000bJ\u00029AA$\u0011\u001d\u0011),\u0007a\u0001\u0003K\n1\u0001Z5s\u0011\u001d\u0011I,\u0007a\u0001\u0003s\nqA]3rk\u0016\u001cH/A\u0003dY>tW\r\u0006\u0005\u0003@\n\u0015'q\u0019Be)\u0019\t)K!1\u0003D\"9\u0011\u0011\u0018\u000eA\u0004\u0005m\u0006bBA#5\u0001\u000f\u0011q\t\u0005\b\u0005kS\u0002\u0019AA3\u0011\u001d\t9H\u0007a\u0001\u0003sBq!a\u0006\u001b\u0001\u0004\tI\"A\u0005mSN$h)\u001b7fgRA!q\u001aBm\u00057\u0014y\u000e\u0006\u0003\u0003R\n]\u0007c\u0001,\u0003T&\u0019!Q['\u0003\u001b\u001dKG\u000fT5tiJ+7/\u001e7u\u0011\u001d\t)e\u0007a\u0002\u0003\u000fBqA!.\u001c\u0001\u0004\t)\u0007\u0003\u0004\u0003^n\u0001\r!Y\u0001\u0007G>lW.\u001b;\t\u0013\t\u00058\u0004%AA\u0002\t5\u0012aE7bq\u001aKG.Z*ju\u0016\u0014\u0015\u0010^3t\u001fB$\u0018a\u00057jgR4\u0015\u000e\\3tI\u0011,g-Y;mi\u0012\u001a\u0014\u0001D2iC:<W\r\u001a$jY\u0016\u001cHC\u0002Bu\u0005o\u0014I\u0010\u0006\u0003\u0003l\nU\b#\u0002Bw\u0005g\fWB\u0001Bx\u0015\r\u0011\tpZ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\t\u0005_Dq!!\u0012\u001e\u0001\b\t9\u0005C\u0004\u00036v\u0001\r!!\u001a\t\r\tmX\u00041\u0001b\u00035\u0019WO\u001d:f]R\u001cu.\\7ji\u0006iq-\u001a;D_6l\u0017\u000e\u001e#jM\u001a$\"b!\u0001\u0004\u0012\rM1qCB\u000e)\u0011\u0019\u0019aa\u0004\u0011\t\r\u001511B\u0007\u0003\u0007\u000fQ1a!\u0003P\u0003\u0011!\u0017N\u001a4\n\t\r51q\u0001\u0002\u000b\u0007>lW.\u001b;ES\u001a4\u0007bBA#=\u0001\u000f\u0011q\t\u0005\b\u0005ks\u0002\u0019AA3\u0011\u001d\u0019)B\ba\u0001\u0005\u000b\nAb]8ve\u000e,7i\\7nSRDqa!\u0007\u001f\u0001\u0004\t\u0019!\u0001\neKN$\u0018N\\1uS>t7i\\7nSR\u001c\bbBB\u000f=\u0001\u00071qD\u0001\u0004g24\u0007\u0003\u00022\u0004\"\u0005L1aa\tn\u0005\r\u0019V\r^\u0001\u0013O\u0016$\b+\u001e7m%\u0016\fX/Z:u\t&4g\r\u0006\u0006\u0004*\r52qFB\u0019\u0007g!Baa\u0001\u0004,!9\u0011QI\u0010A\u0004\u0005\u001d\u0003b\u0002B[?\u0001\u0007\u0011Q\r\u0005\b\u0005_z\u0002\u0019\u0001B#\u0011\u0019\u0011\u0019h\ba\u0001C\"91QD\u0010A\u0002\r}\u0011aD4fi\u001aKG.Z\"p]R,g\u000e^:\u0015\u0011\re21IB#\u0007\u000f\"Baa\u000f\u0004BA\u0019ak!\u0010\n\u0007\r}RJA\bHSR4\u0015\u000e\\3D_:$XM\u001c;t\u0011\u001d\t)\u0005\ta\u0002\u0003\u000fBqA!.!\u0001\u0004\t)\u0007C\u0004\u0003^\u0002\u0002\rA!\u0012\t\r\r%\u0003\u00051\u0001b\u0003!1\u0017\u000e\\3oC6,\u0017A\u00047jgR\fE\u000e\\\"p[6LGo\u001d\u000b\u0005\u0007\u001f\u001a\u0019\u0006\u0006\u0003\u0002~\u000eE\u0003bBA#C\u0001\u000f\u0011q\t\u0005\b\u0005k\u000b\u0003\u0019AA3\u0003Ea\u0017n\u001d;Ce\u0006t7\r[\"p[6LGo\u001d\u000b\u000b\u00073\u001aifa\u0018\u0004b\r\rD\u0003\u0002B\n\u00077Bq!!\u0012#\u0001\b\t9\u0005C\u0004\u00036\n\u0002\r!!\u001a\t\u000f\u0005]$\u00051\u0001\u0002z!9!\u0011\u0005\u0012A\u0002\t\r\u0002b\u0002B\u0016E\u0001\u0007!QF\u0001\u0014Y&\u001cHO\u0011:b]\u000eDWm]\"p[6LGo\u001d\u000b\u0007\u0007S\u001aiga\u001c\u0015\t\tM11\u000e\u0005\b\u0003\u000b\u001a\u00039AA$\u0011\u001d\u0011)l\ta\u0001\u0003KBqA!\u0018$\u0001\u0004\u0011y\u0006\u0006\u0006\u0004t\r]4\u0011PB>\u0007{\"BAa\u0011\u0004v!9\u0011Q\t\u0013A\u0004\u0005\u001d\u0003b\u0002B[I\u0001\u0007\u0011Q\r\u0005\b\u0003o\"\u0003\u0019AA=\u0011\u001d\u0011\t\u0003\na\u0001\u0005GAqaa %\u0001\u0004\u0011)%A\u0006mS6LGoQ8n[&$\u0018A\u00059beN,'I]1oG\"\u001cu.\\7jiN$ba!\"\u0004\n\u000eUE\u0003\u0002B\n\u0007\u000fCq!!\u0012&\u0001\b\t9\u0005C\u0004\u0004\f\u0016\u0002\ra!$\u0002\r1|wmQ7e!\u0011\u0019yi!%\u000e\u0003=K1aa%P\u0005A\u0019u.\\7b]\u0012<\u0016\u000e\u001e5QCJ\fW\u000eC\u0004\u00036\u0016\u0002\r!!\u001a\u0015\u0011\re5QTBP\u0007C#BAa\u001a\u0004\u001c\"9\u0011Q\t\u0014A\u0004\u0005\u001d\u0003b\u0002B[M\u0001\u0007\u0011Q\r\u0005\b\u0005_2\u0003\u0019\u0001B\u0012\u0011\u001d\u0011\u0019H\na\u0001\u0005G\t!c\u0016:ji\u0016<\u0015\u000e\u001e*fa>\u001c\u0018\u000e^8ssB\u0011a\u000bK\n\u0006Q\r%6q\u0016\t\u0005\u00037\u0019Y+C\u0002\u0004.\u001e\u0014a!\u00118z%\u00164\u0007\u0003BA%\u0007cKAaa-\u0002L\tq1i\u001c8uKb$Hj\\4hS:<GCABS\u0003!\u0001(\u000f\u0015:fM&DXCAB^!\u0011\u0019ila1\u000e\u0005\r}&\u0002BBa\u0003[\nA\u0001\\1oO&\u0019Ana0\u0002\u0013A\u0014\bK]3gSb\u0004\u0013aA:fa\u0006!1/\u001a9!\u0003\r)w\u000e\\\u0001\u0005K>d\u0007%\u0001\u0007d_6l\u0017\u000e\u001e$pe6\fG/A\u0007d_6l\u0017\u000e\u001e$pe6\fG\u000fI\u0001\f\u0007>lW.\u001b;NCR\u001c\u0007.\u0006\u0002\u0004XB!1\u0011\\Br\u001b\t\u0019YN\u0003\u0003\u0004^\u000e}\u0017\u0001C7bi\u000eD\u0017N\\4\u000b\u0007\r\u0005x-\u0001\u0003vi&d\u0017\u0002BBs\u00077\u0014QAU3hKb\fAbQ8n[&$X*\u0019;dQ\u0002\n\u0011\u0002Z5gM\u001ac\u0017mZ:\u0016\u0005\r5\bCBBx\u0007k\u001cY,\u0004\u0002\u0004r*!11\u001fBx\u0003%IW.\\;uC\ndW-\u0003\u0003\u0002\u0012\rE\u0018A\u00033jM\u001a4E.Y4tA\u0005\tB-\u001b4g\u0007>lW.\u00198e!J,g-\u001b=\u0002%\u0011LgMZ\"p[6\fg\u000e\u001a)sK\u001aL\u0007\u0010I\u0001\u000bI&4g\r\u0015:fM&D\u0018A\u00033jM\u001a\u001cVO\u001a4jqR!A1\u0001C\u0003!\u0015\t)!a@b\u0011\u001d!9!\u000fa\u0001\u0007?\tQAZ5mKN\fqbR5u\r&dWMU3ta>t7/Z\u0001\u000fSN\u001c\u00160\u001c2pY&\u001cG*\u001b8l)\u0011\tI\u0002b\u0004\t\r\u0011E1\b1\u0001b\u0003\u0005\u0019\u0018\u0001C5t\u0007>lW.\u001b;\u0015\t\u0005eAq\u0003\u0005\u0007\t#a\u0004\u0019A1\u0002?\u0005$Gm\u0014:jO&t'+\u001a4fe\u0016t7-Z\"p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0003\u0005\u001e\u0011\u0005B\u0003BAS\t?Aq!!\u0012>\u0001\b\t9\u0005C\u0004\u00036v\u0002\r!!\u001a\u0002C\u0005$GmR5u\u0011V\u0014\u0007+\u001e7m%\u0016\fX/Z:u\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\t\u0011\u001dB1\u0006\u000b\u0005\u0003K#I\u0003C\u0004\u0002Fy\u0002\u001d!a\u0012\t\u000f\tUf\b1\u0001\u0002f\u0005a\u0011\r\u001a3HSR\u001cuN\u001c4jORAA\u0011\u0007C\u001b\to!Y\u0004\u0006\u0003\u0002&\u0012M\u0002bBA#\u007f\u0001\u000f\u0011q\t\u0005\b\u0005k{\u0004\u0019AA3\u0011\u0019!Id\u0010a\u0001C\u0006!a.Y7f\u0011\u0019!id\u0010a\u0001C\u0006)a/\u00197vK\u0006Y\u0011n\u001d,bY&$'+\u001a9p)\u0019!\u0019\u0005\"\u0013\u0005LQ!AQ\tC$!\u0019\tYBa\f\u0002\u001a!9\u0011Q\t!A\u0004\u0005\u001d\u0003b\u0002B[\u0001\u0002\u0007\u0011Q\r\u0005\n\t\u001b\u0002\u0005\u0013!a\u0001\t\u001f\n!bY8n[&$X+^5e!\u0015\tYBa\fb\u0003UI7OV1mS\u0012\u0014V\r]8%I\u00164\u0017-\u001e7uII*\"\u0001\"\u0016+\t\u0011=\u00131\u0012\u000b\u0005\t3\"i\u0006\u0006\u0003\u0003\u001a\u0012m\u0003bBA#\u0005\u0002\u000f\u0011q\t\u0005\b\u0005G\u0013\u0005\u0019\u0001BS\u00039\u0001\u0018M]:f\u0007>lW.\u001b;M_\u001e$B\u0001b\u0019\u0005jQ!AQ\rC4!\u0019\tYBa\f\u0003\u0016!9\u0011QI\"A\u0004\u0005\u001d\u0003B\u0002C6\u0007\u0002\u0007\u0011-A\u0005d_6l\u0017\u000e\u001e'pO\u0006Q!\t\\1nK6\u000bGo\u00195\u0002\u0017\tc\u0017-\\3NCR\u001c\u0007\u000eI\u0001\n\r&dW-T1uG\"\f!BR5mK6\u000bGo\u00195!\u0003)\u0001\u0018M]:f\u00052\fW.\u001a\u000b\u0007\ts\"\t\t\"\"\u0011\r\u0005m!q\u0006C>!\r1FQP\u0005\u0004\t\u007fj%!\u0002\"mC6,\u0007B\u0002CB\u0011\u0002\u0007\u0011-\u0001\u0006cY\u0006lW\rT5oKFBa\u0001b\"I\u0001\u0004\t\u0017A\u00032mC6,G*\u001b8fe\u0005iA)\u001b4g\u0019&tW\rT5nSR,\"Aa\r\u0002\u001d\u0011KgM\u001a'j]\u0016d\u0015.\\5uA\u0005\u0019R\r_3dkR,\u0017I\u001c3QCJ\u001cX\rR5gMR1A1\u0013CL\t7#Baa\u0001\u0005\u0016\"9\u0011QI&A\u0004\u0005\u001d\u0003b\u0002CM\u0017\u0002\u0007\u00111A\u0001\fI&4gmQ8n[\u0006tG\rC\u0004\u00036.\u0003\r!!\u001a")
public abstract class WriteGitRepository
extends GitRepository
implements FileSystemLocks {
    private final String repositoryKeysLocation;
    private final String repositoryLocation;

    public static Regex FileMatch() {
        return WriteGitRepository$.MODULE$.FileMatch();
    }

    public static Regex BlameMatch() {
        return WriteGitRepository$.MODULE$.BlameMatch();
    }

    public static String commitFormat() {
        return WriteGitRepository$.MODULE$.commitFormat();
    }

    public static String eol() {
        return WriteGitRepository$.MODULE$.eol();
    }

    public static String sep() {
        return WriteGitRepository$.MODULE$.sep();
    }

    public static String prPrefix() {
        return WriteGitRepository$.MODULE$.prPrefix();
    }

    @Override
    public <A> A lock(File file, long maxTime, Function1<FileSystemLocks.Lock, A> method) {
        return (A)FileSystemLocks.lock$(this, file, maxTime, method);
    }

    @Override
    public <A> long lock$default$2() {
        return FileSystemLocks.lock$default$2$(this);
    }

    public String repositoryKeysLocation() {
        return this.repositoryKeysLocation;
    }

    public String repositoryLocation() {
        return this.repositoryLocation;
    }

    public scala.collection.immutable.Seq<String> cloneOptions(boolean recursive) {
        if (recursive) {
            return new .colon.colon((Object)"--recursive", (List)Nil$.MODULE$);
        }
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    public String pathPrefix() {
        return "p_";
    }

    public abstract <T> T withRepository(ProjectRequest var1, boolean var2, Function1<File, T> var3, ProjectLogContext var4);

    public <T> boolean withRepository$default$2() {
        return false;
    }

    public abstract void updateRepository(ProjectRequest var1, ProjectLogContext var2);

    public void pullChangesOrClone(ProjectRequest projectReq, File projectDir, boolean cloneSubmodules, FileSystemLocks.Lock l, ProjectLogContext logContext) {
        this.logger().info(new StringBuilder(43).append("Updating repository with cloneSubmodules = ").append(cloneSubmodules).toString(), (LogContext)logContext);
        Option<Object> isValidHeadRsp = WriteGitRepository$.MODULE$.isValidRepo(projectDir, WriteGitRepository$.MODULE$.isValidRepo$default$2(), logContext);
        boolean isValidHead = BoxesRunTime.unboxToBoolean((Object)isValidHeadRsp.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        if (isValidHead) {
            this.pullChanges(projectDir, projectReq, logContext);
            return;
        }
        this.cleanAndClone(projectReq, projectDir, cloneSubmodules, l, logContext);
    }

    public File pullChangesOrClone(ProjectRequest project, File projectDir, boolean forceUpdate, boolean cloneSubmodules, FileSystemLocks.Lock l, ProjectLogContext logContext) {
        block1: {
            Option<Object> isValidHeadRsp = WriteGitRepository$.MODULE$.isValidRepo(projectDir, WriteGitRepository$.MODULE$.isValidRepo$default$2(), logContext);
            boolean isValidHead = BoxesRunTime.unboxToBoolean((Object)isValidHeadRsp.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
            if (!isValidHead) {
                this.logger().warn(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(68).append("Forcing removal of HEAD ").append(projectDir.getAbsolutePath()).append(" under conditions:\n           |isValidHead: ").append(isValidHead).toString())), (LogContext)logContext);
                this.cleanAndClone(project, projectDir, cloneSubmodules, l, logContext);
                return projectDir;
            }
            if (!forceUpdate) break block1;
            this.pullChanges(projectDir, project, logContext);
        }
        return projectDir;
    }

    private void cleanAndClone(ProjectRequest projectReq, File projectDir, boolean cloneSubmodules, FileSystemLocks.Lock l, ProjectLogContext logContext) {
        this.recreateProjectDir(projectDir, logContext);
        try {
            this.clone(projectDir, projectReq, cloneSubmodules, l, logContext);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable err = (Throwable)option.get();
                this.recreateProjectDir(projectDir, logContext);
                throw err;
            }
            throw throwable;
        }
    }

    public List<GitCommitWithIndex> getAllCommits(ProjectRequest project, ProjectLogContext logContext) {
        return (List)this.logger().time("Getting all commits", this.logger().time$default$2(), this.logger().time$default$3(), (Function0 & Serializable)() -> (List)this.withRepository(project, this.withRepository$default$2(), (Function1 & Serializable)directory -> this.listAllCommits((File)directory, logContext), logContext), (LogContext)logContext);
    }

    public List<GitCommit> getBranchCommits(ProjectRequest project, BranchRequest branch, Option<Object> limit, ProjectLogContext logContext) {
        return (List)this.logger().time(new StringBuilder(34).append("Getting branch commits for branch ").append(branch.name()).toString(), this.logger().time$default$2(), this.logger().time$default$3(), (Function0 & Serializable)() -> (List)this.withRepository(project, this.withRepository$default$2(), (Function1 & Serializable)directory -> this.listBranchCommits((File)directory, project, branch, limit, logContext), logContext), (LogContext)logContext);
    }

    public List<CommitRequest> getBranchCommits(ProjectRequest project, BranchRequest branch, CommitRequest limit, ProjectLogContext logContext) {
        return (List)this.logger().time(new StringBuilder(34).append("Getting branch commits for branch ").append(branch.name()).toString(), this.logger().time$default$2(), this.logger().time$default$3(), (Function0 & Serializable)() -> (List)this.withRepository(project, this.withRepository$default$2(), (Function1 & Serializable)directory -> this.listBranchCommits((File)directory, project, branch, limit, logContext), logContext), (LogContext)logContext);
    }

    public List<GitCommit> getBranchCommits(ProjectRequest project, scala.collection.immutable.Seq<BranchRequest> branches, ProjectLogContext logContext) {
        return (List)this.logger().time("Getting commits for selected branches", this.logger().time$default$2(), this.logger().time$default$3(), (Function0 & Serializable)() -> (List)this.withRepository(project, this.withRepository$default$2(), (Function1 & Serializable)directory -> this.listBranchesCommits((File)directory, branches, logContext), logContext), (LogContext)logContext);
    }

    public Option<Object> getBranchCommits$default$3() {
        return None$.MODULE$;
    }

    public Option<CommitRequest> findCommonAncestor(ProjectRequest project, BranchRequest source, BranchRequest destination, ProjectLogContext logContext) {
        return (Option)this.logger().time(new StringBuilder(45).append("Getting common ancestor commit for branches ").append(source.name()).append(":").append(destination.name()).toString(), this.logger().time$default$2(), this.logger().time$default$3(), (Function0 & Serializable)() -> (Option)this.withRepository(project, this.withRepository$default$2(), (Function1 & Serializable)directory -> this.findCommonAncestor((File)directory, source, destination, logContext), logContext), (LogContext)logContext);
    }

    public void cleanProjectDir(String projectUrl, ProjectLogContext logContext) {
        File projectDir = this.getProjectPath(projectUrl);
        this.lock(projectDir, this.lock$default$2(), (Function1 & Serializable)l -> {
            this.recreateProjectDir(projectDir, logContext);
            return BoxedUnit.UNIT;
        });
    }

    private void recreateProjectDir(File projectDir, ProjectLogContext logContext) {
        FileOperations$.MODULE$.deleteDirectory(projectDir, logContext);
        FileOperations$.MODULE$.createDirectory(projectDir, logContext);
    }

    public File getProjectPath(String iurl) {
        return Paths.get(this.repositoryLocation(), new String[0]).resolve(new StringBuilder(0).append(this.pathPrefix()).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(CryptoTools$.MODULE$.sha256Alphanumeric(iurl).toLowerCase()), 16)).toString()).toFile();
    }

    public RepositoryData generateProjectData(Map<String, String> values, ProjectLogContext logContext) {
        return WriteGitRepository$.MODULE$.generateProjectData(values, logContext);
    }

    public void pullChanges(File dir, ProjectRequest request, ProjectLogContext logContext) {
        .colon.colon command = new .colon.colon((Object)"git", (List)new .colon.colon((Object)"fetch", (List)new .colon.colon((Object)"--all", (List)new .colon.colon((Object)"--prune", (List)new .colon.colon((Object)"--force", (List)Nil$.MODULE$)))));
        CommandWithParam commandWithAuth = this.wrapCommandWithAuthorization(request, (scala.collection.immutable.Seq<String>)command, logContext);
        GitCommandRunner$.MODULE$.execNoOutput(commandWithAuth, (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.execNoOutput$default$3(), logContext);
    }

    private void clone(File dir, ProjectRequest project, boolean recursive, FileSystemLocks.Lock l, ProjectLogContext logContext) {
        RepositoryData projectData;
        String url = this.processProjectUrl(project, logContext);
        scala.collection.immutable.Seq cmd = (scala.collection.immutable.Seq)((IterableOps)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"clone", (List)Nil$.MODULE$)).$plus$plus(this.cloneOptions(recursive))).$plus$plus((IterableOnce)new .colon.colon((Object)url, (List)new .colon.colon((Object)dir.getAbsolutePath(), (List)Nil$.MODULE$)));
        RepositoryData repositoryData = project.data();
        RepositoryData x$1 = projectData = repositoryData instanceof AccessTokenRepositoryData ? new AccessTokenInUrl(project.data().value()) : repositoryData;
        String x$2 = project.copy$default$1();
        CommandWithParam cloneCommand = this.wrapCommandWithAuthorization(project.copy(x$2, x$1), (scala.collection.immutable.Seq<String>)cmd, logContext);
        GitCommandRunner$.MODULE$.execNoOutput(cloneCommand, (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.execNoOutput$default$3(), logContext);
        BoxedUnit cloneCmdResponse = BoxedUnit.UNIT;
        WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$addOriginReferenceConfiguration(dir, logContext);
        WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$addGitHubPullRequestConfiguration(dir, logContext);
        this.pullChanges(dir, project, logContext);
    }

    public GitListResult listFiles(File dir, String commit, Option<Object> maxFileSizeBytesOpt, ProjectLogContext logContext) {
        this.logger().debug(new StringBuilder(17).append("Listing files in ").append(dir.getAbsolutePath()).toString(), (LogContext)logContext);
        List files = ((ListBuffer)((SeqOps)GitCommandRunner$.MODULE$.exec((scala.collection.immutable.Seq<String>)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"ls-tree", (List)new .colon.colon((Object)"-l", (List)new .colon.colon((Object)"-r", (List)new .colon.colon((Object)commit, (List)Nil$.MODULE$))))), (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.exec$default$3(), ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Function2 & Serializable)(prev, line) -> {
            Option option;
            String string = line;
            if (string != null && !(option = WriteGitRepository$.MODULE$.GitFileResponse().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(5) == 0) {
                String mode = (String)((LinearSeqOps)option.get()).apply(0);
                String t = (String)((LinearSeqOps)option.get()).apply(1);
                String hash = (String)((LinearSeqOps)option.get()).apply(2);
                String size = (String)((LinearSeqOps)option.get()).apply(3);
                String filename = (String)((LinearSeqOps)option.get()).apply(4);
                if (!WriteGitRepository$.MODULE$.isSymbolicLink(mode) && !WriteGitRepository$.MODULE$.isCommit(t)) {
                    return (ListBuffer)prev.$plus$eq((Object)new GitFile(filename, hash, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(size))));
                }
            }
            return prev;
        }, logContext)).distinct()).toList();
        Option<Object> option = maxFileSizeBytesOpt;
        if (None$.MODULE$.equals(option)) {
            return new GitListResult((List<GitFile>)files, (List<GitFile>)Nil$.MODULE$);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            int maxFileSize = BoxesRunTime.unboxToInt((Object)some.value());
            return (GitListResult)GitListResult$.MODULE$.tupled().apply((Object)files.partition((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)WriteGitRepository.$anonfun$listFiles$2(maxFileSize, x$1))));
        }
        throw new MatchError(option);
    }

    public Option<Object> listFiles$default$3() {
        return Option$.MODULE$.empty();
    }

    public Seq<String> changedFiles(File dir, String currentCommit, ProjectLogContext logContext) {
        this.logger().debug(new StringBuilder(28).append("Retrieving changed files in ").append(dir.getAbsolutePath()).toString(), (LogContext)logContext);
        return (Seq)GitCommandRunner$.MODULE$.exec((scala.collection.immutable.Seq<String>)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"show", (List)new .colon.colon((Object)"--first-parent", (List)new .colon.colon((Object)"--pretty=format:", (List)new .colon.colon((Object)"--name-only", (List)new .colon.colon((Object)currentCommit, (List)Nil$.MODULE$)))))), (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.exec$default$3(), ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Function2 & Serializable)(prev, line) -> {
            String trimmed = line.trim();
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(trimmed))) {
                return (ListBuffer)prev.$plus$eq((Object)line.trim());
            }
            return prev;
        }, logContext);
    }

    public CommitDiff getCommitDiff(File dir, CommitRequest sourceCommit, scala.collection.immutable.Seq<String> destinationCommits, Set<String> slf, ProjectLogContext logContext) {
        scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)destinationCommits.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2.trim()))));
        scala.collection.immutable.Seq diffCommand = seq.length() > 1 ? (scala.collection.immutable.Seq)((IterableOps)WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$diffCommandPrefix().$plus$plus((IterableOnce)new .colon.colon((Object)sourceCommit.uuid(), (List)Nil$.MODULE$))).$plus$plus(destinationCommits) : (scala.collection.immutable.Seq)seq.lastOption().fold((Function0 & Serializable)() -> (scala.collection.immutable.Seq)((IterableOps)((IterableOps)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"show", (List)new .colon.colon((Object)"--format=", (List)Nil$.MODULE$))).$plus$plus(WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$diffPrefix())).$plus$plus((IterableOnce)new .colon.colon((Object)sourceCommit.uuid(), (List)Nil$.MODULE$))).$plus$plus(WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$diffSuffix(slf)), (Function1 & Serializable)lastCommit -> (scala.collection.immutable.Seq)((IterableOps)WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$diffCommandPrefix().$plus$plus((IterableOnce)new .colon.colon(lastCommit, (List)new .colon.colon((Object)sourceCommit.uuid(), (List)Nil$.MODULE$)))).$plus$plus(WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$diffSuffix(slf)));
        return WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$executeAndParseDiff((scala.collection.immutable.Seq<String>)diffCommand, dir, logContext);
    }

    public CommitDiff getPullRequestDiff(File dir, CommitRequest source, String destination, Set<String> slf, ProjectLogContext logContext) {
        scala.collection.immutable.Seq command = (scala.collection.immutable.Seq)((IterableOps)WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$diffCommandPrefix().$plus$plus((IterableOnce)new .colon.colon((Object)new StringBuilder(3).append(destination).append("...").append(source.uuid()).toString(), (List)Nil$.MODULE$))).$plus$plus(WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$diffSuffix(slf));
        this.logger().info(new StringBuilder(31).append("Getting pull request diff. cmd:").append(command.mkString(" ")).toString(), (LogContext)logContext);
        return WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$executeAndParseDiff((scala.collection.immutable.Seq<String>)command, dir, logContext);
    }

    public GitFileContents getFileContents(File dir, CommitRequest commit, String filename, ProjectLogContext logContext) {
        .colon.colon command = new .colon.colon((Object)"git", (List)new .colon.colon((Object)"show", (List)new .colon.colon((Object)new StringBuilder(1).append(commit.uuid()).append(":").append(filename).toString(), (List)Nil$.MODULE$)));
        return new GitFileContents(filename, (List<String>)((ListBuffer)GitCommandRunner$.MODULE$.exec((scala.collection.immutable.Seq<String>)command, (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.exec$default$3(), ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Function2 & Serializable)(acc, line) -> (ListBuffer)acc.$plus$eq(line), logContext)).toList(), GitFileContents$.MODULE$.apply$default$3());
    }

    public List<GitCommitWithIndex> listAllCommits(File dir, ProjectLogContext logContext) {
        .colon.colon logCmd = new .colon.colon((Object)"git", (List)new .colon.colon((Object)"log", (List)new .colon.colon((Object)"--all", (List)new .colon.colon((Object)"--encoding=UTF-8", (List)new .colon.colon((Object)"--date=local", (List)new .colon.colon((Object)new StringBuilder(16).append("--pretty=format:").append(WriteGitRepository$.MODULE$.commitFormat()).toString(), (List)Nil$.MODULE$))))));
        return ((ListBuffer)((StrictOptimizedIterableOps)((StrictOptimizedIterableOps)GitCommandRunner$.MODULE$.exec((scala.collection.immutable.Seq<String>)logCmd, (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.exec$default$3(), ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Function2 & Serializable)(prev, line) -> {
            Option<GitCommit> option = WriteGitRepository$.MODULE$.parseCommitLog((String)line, logContext);
            if (option instanceof Some) {
                GitCommit commit;
                Some some = (Some)option;
                GitCommit gitCommit = commit = (GitCommit)some.value();
                return (ListBuffer)prev.$plus$eq$colon((Object)gitCommit);
            }
            if (None$.MODULE$.equals(option)) {
                return prev;
            }
            throw new MatchError(option);
        }, logContext)).zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                GitCommit e = (GitCommit)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (e != null) {
                    GitCommit gitCommit = e;
                    if (true) {
                        int n = i;
                        return new GitCommitWithIndex(gitCommit, n);
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        })).toList();
    }

    private List<GitCommit> listBranchCommits(File dir, ProjectRequest project, BranchRequest branch, Option<Object> limit, ProjectLogContext logContext) {
        scala.collection.immutable.Seq limitArgs = (scala.collection.immutable.Seq)limit.map((Function1 & Serializable)l -> WriteGitRepository.$anonfun$listBranchCommits$1(BoxesRunTime.unboxToInt((Object)l))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty());
        CommandWithParam logCmd = this.wrapCommandWithAuthorization(project, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"log", (List)new .colon.colon((Object)"--encoding=UTF-8", (List)new .colon.colon((Object)"--date=local", (List)new .colon.colon((Object)new StringBuilder(16).append("--pretty=format:").append(WriteGitRepository$.MODULE$.commitFormat()).toString(), (List)new .colon.colon((Object)new StringBuilder(15).append("remotes/origin/").append(branch.name()).toString(), (List)Nil$.MODULE$)))))).$plus$plus((IterableOnce)limitArgs)), logContext);
        return this.parseBranchCommits(logCmd, dir, logContext);
    }

    private List<GitCommit> listBranchesCommits(File dir, scala.collection.immutable.Seq<BranchRequest> branches, ProjectLogContext logContext) {
        scala.collection.immutable.Seq branchNames = (scala.collection.immutable.Seq)branches.map((Function1 & Serializable)branch -> new StringBuilder(15).append("remotes/origin/").append(branch.name()).toString());
        scala.collection.immutable.Seq logCmd = (scala.collection.immutable.Seq)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"log", (List)new .colon.colon((Object)"--encoding=UTF-8", (List)new .colon.colon((Object)"--date=local", (List)new .colon.colon((Object)new StringBuilder(16).append("--pretty=format:").append(WriteGitRepository$.MODULE$.commitFormat()).toString(), (List)Nil$.MODULE$))))).$plus$plus((IterableOnce)branchNames);
        return this.parseBranchCommits(new CommandWithParam((scala.collection.immutable.Seq<String>)logCmd, CommandWithParam$.MODULE$.apply$default$2()), dir, logContext);
    }

    private List<CommitRequest> listBranchCommits(File dir, ProjectRequest project, BranchRequest branch, CommitRequest limitCommit, ProjectLogContext logContext) {
        CommandWithParam cmd = this.wrapCommandWithAuthorization(project, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"rev-list", (List)new .colon.colon((Object)new StringBuilder(17).append(limitCommit.uuid()).append("..remotes/origin/").append(branch.name()).toString(), (List)Nil$.MODULE$))), logContext);
        return ((ListBuffer)GitCommandRunner$.MODULE$.exec(cmd, (Option<File>)Option$.MODULE$.apply((Object)dir), (Option<Duration>)None$.MODULE$, ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Function2 & Serializable)(prev, line) -> (ListBuffer)prev.$plus$eq((Object)new CommitRequest((String)line)), logContext)).toList();
    }

    private List<GitCommit> parseBranchCommits(CommandWithParam logCmd, File dir, ProjectLogContext logContext) {
        return ((ListBuffer)GitCommandRunner$.MODULE$.exec(logCmd, (Option<File>)new Some((Object)dir), (Option<Duration>)None$.MODULE$, ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Function2 & Serializable)(prev, line) -> {
            Option<GitCommit> option = WriteGitRepository$.MODULE$.parseCommitLog((String)line, logContext);
            if (option instanceof Some) {
                Some some = (Some)option;
                GitCommit commit = (GitCommit)some.value();
                return (ListBuffer)prev.$plus$eq((Object)commit);
            }
            if (None$.MODULE$.equals(option)) {
                return prev;
            }
            throw new MatchError(option);
        }, logContext)).toList();
    }

    private Option<CommitRequest> findCommonAncestor(File dir, BranchRequest source, BranchRequest destination, ProjectLogContext logContext) {
        .colon.colon cmd = new .colon.colon((Object)"git", (List)new .colon.colon((Object)"merge-base", (List)new .colon.colon((Object)new StringBuilder(15).append("remotes/origin/").append(source.name()).toString(), (List)new .colon.colon((Object)new StringBuilder(15).append("remotes/origin/").append(destination.name()).toString(), (List)Nil$.MODULE$))));
        return (Option)GitCommandRunner$.MODULE$.exec((scala.collection.immutable.Seq<String>)cmd, (Option<File>)Option$.MODULE$.apply((Object)dir), GitCommandRunner$.MODULE$.exec$default$3(), None$.MODULE$, (Function2 & Serializable)(prev, line) -> {
            Option option = prev;
            if (None$.MODULE$.equals(option)) {
                return new Some((Object)new CommitRequest((String)line));
            }
            return prev;
        }, logContext);
    }

    public static final /* synthetic */ boolean $anonfun$listFiles$2(int maxFileSize$1, GitFile x$1) {
        return x$1.bytes() < maxFileSize$1;
    }

    public static final /* synthetic */ scala.collection.immutable.Seq $anonfun$listBranchCommits$1(int l) {
        return new .colon.colon((Object)"-n", (List)new .colon.colon((Object)Integer.toString(l), (List)Nil$.MODULE$));
    }

    public WriteGitRepository(String repositoryKeysLocation, String repositoryLocation, ExecutionContext executionContext) {
        this.repositoryKeysLocation = repositoryKeysLocation;
        this.repositoryLocation = repositoryLocation;
        super(repositoryKeysLocation, executionContext);
        FileSystemLocks.$init$(this);
    }
}

