/*
 * Decompiled with CFR 0.152.
 */
package codacy.git.runners;

import codacy.foundation.logging.context.ContextAwareLogger;
import codacy.foundation.logging.context.ContextLogging;
import codacy.foundation.logging.context.LogContext;
import codacy.git.runners.CommandExecutionContext$;
import codacy.git.runners.ProcessResult;
import java.io.InputStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.io.BufferedSource;
import scala.io.Source;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.sys.process.Process;
import scala.sys.process.ProcessIO;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e\u0001B\u000e\u001d\u0001\rB\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\t\u0013\u0002\u0011\t\u0011)A\u0006\u0015\")Q\n\u0001C\u0001\u001d\"9A\u000b\u0001b\u0001\n\u0013)\u0006B\u00020\u0001A\u0003%a\u000bC\u0004`\u0001\t\u0007I\u0011B+\t\r\u0001\u0004\u0001\u0015!\u0003W\u0011\u001d\t\u0007A1A\u0005\n\tDaa\u001b\u0001!\u0002\u0013\u0019\u0007b\u00024\u0001\u0005\u0004%I\u0001\u001c\u0005\u0007a\u0002\u0001\u000b\u0011B7\t\u000bE\u0004A\u0011\u0001:\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006!9\u0011Q\u0002\u0001\u0005\n\u0005=qaBA\u00159!\u0005\u00111\u0006\u0004\u00077qA\t!!\f\t\r5\u0003B\u0011AA\u0018\u0011%\t\t\u0004\u0005b\u0001\n\u0013\t\u0019\u0004\u0003\u0005\u0002@A\u0001\u000b\u0011BA\u001b\r\u0019\t\t\u0005\u0005\u0003\u0002D!Q\u00111\u0003\u000b\u0003\u0002\u0003\u0006I!!\u0006\t\r5#B\u0011AA&\r\u0019\t\u0019\u0006\u0006\u0003\u0002V!1Qj\u0006C\u0001\u0003GBq!a\u001a\u0018\t\u0003\nI\u0007C\u0004\u0002|Q!\t%! \u0003/\r{W.\\1oI\u0016CXmY;uS>t7i\u001c8uKb$(BA\u000f\u001f\u0003\u001d\u0011XO\u001c8feNT!a\b\u0011\u0002\u0007\u001dLGOC\u0001\"\u0003\u0019\u0019w\u000eZ1ds\u000e\u00011c\u0001\u0001%UA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t1\u0011I\\=SK\u001a\u0004\"a\u000b\u001a\u000e\u00031R!!\f\u0018\u0002\u000f\r|g\u000e^3yi*\u0011q\u0006M\u0001\bY><w-\u001b8h\u0015\t\t\u0004%\u0001\u0006g_VtG-\u0019;j_:L!a\r\u0017\u0003\u001d\r{g\u000e^3yi2{wmZ5oO\u000691m\\7nC:$\u0007c\u0001\u001c?\u0003:\u0011q\u0007\u0010\b\u0003qmj\u0011!\u000f\u0006\u0003u\t\na\u0001\u0010:p_Rt\u0014\"A\u0014\n\u0005u2\u0013a\u00029bG.\fw-Z\u0005\u0003\u007f\u0001\u00131aU3r\u0015\tid\u0005\u0005\u0002C\r:\u00111\t\u0012\t\u0003q\u0019J!!\u0012\u0014\u0002\rA\u0013X\rZ3g\u0013\t9\u0005J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000b\u001a\n!\u0002\\8h\u0007>tG/\u001a=u!\tY3*\u0003\u0002MY\tQAj\\4D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\ty5\u000b\u0006\u0002Q%B\u0011\u0011\u000bA\u0007\u00029!)\u0011j\u0001a\u0002\u0015\")Ag\u0001a\u0001k\u0005a1\u000f\u001e3pkR\u0014UO\u001a4feV\ta\u000bE\u0002X9\u0006k\u0011\u0001\u0017\u0006\u00033j\u000bq!\\;uC\ndWM\u0003\u0002\\M\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005uC&aC!se\u0006L()\u001e4gKJ\fQb\u001d;e_V$()\u001e4gKJ\u0004\u0013\u0001D:uI\u0016\u0014(OQ;gM\u0016\u0014\u0018!D:uI\u0016\u0014(OQ;gM\u0016\u0014\b%A\u0005qe>\u001cWm]:J\u001fV\t1\r\u0005\u0002eS6\tQM\u0003\u0002gO\u00069\u0001O]8dKN\u001c(B\u00015'\u0003\r\u0019\u0018p]\u0005\u0003U\u0016\u0014\u0011\u0002\u0015:pG\u0016\u001c8/S(\u0002\u0015A\u0014xnY3tg&{\u0005%F\u0001n!\t!g.\u0003\u0002pK\n9\u0001K]8dKN\u001c\u0018\u0001\u00039s_\u000e,7o\u001d\u0011\u0002\u001f\u0015DXmY;uS>tg)\u001e;ve\u0016$\"a\u001d?\u0011\u0007Q<\u00180D\u0001v\u0015\t1h%\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001_;\u0003\r\u0019+H/\u001e:f!\t\t&0\u0003\u0002|9\ti\u0001K]8dKN\u001c(+Z:vYRDQ! \u0007A\u0004y\f\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0011\u0005Q|\u0018bAA\u0001k\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\bG2,\u0017M\\;q)\t\t9\u0001E\u0002&\u0003\u0013I1!a\u0003'\u0005\u0011)f.\u001b;\u0002+]\u0014\u0018\u000e^3U_\n+hMZ3s\u0003:$7\t\\8tKR1\u0011qAA\t\u0003KAq!a\u0005\u000f\u0001\u0004\t)\"A\u0006j]B,Ho\u0015;sK\u0006l\u0007\u0003BA\f\u0003Ci!!!\u0007\u000b\t\u0005m\u0011QD\u0001\u0003S>T!!a\b\u0002\t)\fg/Y\u0005\u0005\u0003G\tIBA\u0006J]B,Ho\u0015;sK\u0006l\u0007BBA\u0014\u001d\u0001\u0007a+\u0001\u0004ck\u001a4WM]\u0001\u0018\u0007>lW.\u00198e\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\"!\u0015\t\u0014\u0005A!CCAA\u0016\u0003\u0015\u0019w\u000eZ3d+\t\t)\u0004\u0005\u0003\u00028\u0005mRBAA\u001d\u0015\r\tYBJ\u0005\u0005\u0003{\tIDA\u0003D_\u0012,7-\u0001\u0004d_\u0012,7\r\t\u0002\u001a\u001f:d\u0017PT3x\u0019&tWMQ;gM\u0016\u0014X\rZ*pkJ\u001cWmE\u0002\u0015\u0003\u000b\u0002B!a\u000e\u0002H%!\u0011\u0011JA\u001d\u00059\u0011UO\u001a4fe\u0016$7k\\;sG\u0016$B!!\u0014\u0002RA\u0019\u0011q\n\u000b\u000e\u0003AAq!a\u0005\u0017\u0001\u0004\t)BA\nP]2Lh*Z<MS:,\u0017\n^3sCR|'oE\u0002\u0018\u0003/\u0002B!!\u0017\u0002\\5\tA#\u0003\u0003\u0002^\u0005}#\u0001\u0004'j]\u0016LE/\u001a:bi>\u0014\u0018\u0002BA1\u0003s\u0011aaU8ve\u000e,GCAA3!\r\tIfF\u0001\nSNtUm\u001e7j]\u0016$B!a\u001b\u0002rA\u0019Q%!\u001c\n\u0007\u0005=dEA\u0004C_>dW-\u00198\t\u000f\u0005M\u0014\u00041\u0001\u0002v\u0005\u00111\r\u001b\t\u0004K\u0005]\u0014bAA=M\t!1\t[1s\u0003!9W\r\u001e'j]\u0016\u001cHCAA@!\u00111\u0014\u0011Q!\n\u0007\u0005\r\u0005I\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0001")
public class CommandExecutionContext
implements ContextLogging {
    private final LogContext logContext;
    private final ArrayBuffer<String> stdoutBuffer;
    private final ArrayBuffer<String> stderrBuffer;
    private final ProcessIO processIO;
    private final Process process;
    private transient ContextAwareLogger logger;
    private volatile transient boolean bitmap$trans$0;

    private ContextAwareLogger logger$lzycompute() {
        CommandExecutionContext commandExecutionContext = this;
        synchronized (commandExecutionContext) {
            if (!this.bitmap$trans$0) {
                this.logger = ContextLogging.logger$((ContextLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public ContextAwareLogger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private ArrayBuffer<String> stdoutBuffer() {
        return this.stdoutBuffer;
    }

    private ArrayBuffer<String> stderrBuffer() {
        return this.stderrBuffer;
    }

    private ProcessIO processIO() {
        return this.processIO;
    }

    private Process process() {
        return this.process;
    }

    public Future<ProcessResult> executionFuture(ExecutionContext executionContext) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (ProcessResult)package$.MODULE$.blocking((Function0 & Serializable)() -> {
            int result = this.process().exitValue();
            return new ProcessResult(result, (Seq<String>)this.stdoutBuffer(), (Seq<String>)this.stderrBuffer());
        }), executionContext);
    }

    public void cleanup() {
        Try try_;
        if (this.stderrBuffer().nonEmpty()) {
            this.logger().warn(new StringBuilder(22).append("Command error output: ").append(this.stderrBuffer().mkString("\n")).toString(), this.logContext);
        }
        if ((try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.process().destroy())) instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().warn("Error destroying the process", e, this.logContext);
            return;
        }
    }

    private void writeToBufferAndClose(InputStream inputStream, ArrayBuffer<String> buffer) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            new OnlyNewLineBufferedSource(inputStream).getLines().foreach((Function1 & Serializable)x$1 -> (ArrayBuffer)buffer.$plus$eq(x$1));
            inputStream.close();
        });
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().warn("Error processing the input stream", e, this.logContext);
            inputStream.close();
            return;
        }
    }

    public CommandExecutionContext(scala.collection.immutable.Seq<String> command, LogContext logContext) {
        this.logContext = logContext;
        ContextLogging.$init$((ContextLogging)this);
        this.stdoutBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.stderrBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.processIO = new ProcessIO((Function1 & Serializable)writeInput -> {
            writeInput.close();
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)stdout -> {
            this.writeToBufferAndClose(stdout, this.stdoutBuffer());
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)stderr -> {
            this.writeToBufferAndClose(stderr, this.stderrBuffer());
            return BoxedUnit.UNIT;
        });
        this.process = scala.sys.process.package$.MODULE$.stringSeqToProcess(command).run(this.processIO());
    }

    private static class OnlyNewLineBufferedSource
    extends BufferedSource {
        public Iterator<String> getLines() {
            return new OnlyNewLineIterator(this);
        }

        public OnlyNewLineBufferedSource(InputStream inputStream) {
            super(inputStream, CommandExecutionContext$.MODULE$.codacy$git$runners$CommandExecutionContext$$codec());
        }

        private class OnlyNewLineIterator
        extends Source.LineIterator {
            public boolean isNewline(char ch) {
                return ch == '\n';
            }

            public /* synthetic */ OnlyNewLineBufferedSource codacy$git$runners$CommandExecutionContext$OnlyNewLineBufferedSource$OnlyNewLineIterator$$$outer() {
                return (OnlyNewLineBufferedSource)this.$outer;
            }

            public OnlyNewLineIterator(OnlyNewLineBufferedSource $outer) {
                super((Source)$outer);
            }
        }
    }
}

