/*
 * Decompiled with CFR 0.152.
 */
package codacy.git.runners;

import codacy.foundation.logging.context.ContextAwareLogger;
import codacy.foundation.logging.context.ContextLogging;
import codacy.foundation.logging.context.LogContext;
import codacy.git.CommandWithParam;
import codacy.git.runners.CommandError;
import codacy.git.runners.CommandExecutionContext;
import codacy.git.runners.ProcessResult;
import codacy.git.runners.TimeoutContext;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.process.Process$;
import scala.util.Failure;
import scala.util.Try;

public final class CommandRunner$
implements ContextLogging {
    public static final CommandRunner$ MODULE$ = new CommandRunner$();
    private static transient ContextAwareLogger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        ContextLogging.$init$((ContextLogging)MODULE$);
    }

    private ContextAwareLogger logger$lzycompute() {
        CommandRunner$ commandRunner$ = this;
        synchronized (commandRunner$) {
            if (!bitmap$trans$0) {
                logger = ContextLogging.logger$((ContextLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public ContextAwareLogger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public Future<Seq<String>> runCommand(CommandWithParam command, Duration timeout, ExecutionContext executionContext, LogContext logContext) {
        String commandLog = command.command().mkString("`", " ", "`");
        this.logger().info(new StringBuilder(34).append("Executing command: ").append(commandLog).append(" with timeout: ").append(timeout).toString(), logContext);
        TimeoutContext timeoutContext = new TimeoutContext(timeout);
        CommandExecutionContext commandExecutionContext = new CommandExecutionContext(command.fillTokenPart(), logContext);
        return Future$.MODULE$.firstCompletedOf((IterableOnce)new .colon.colon(commandExecutionContext.executionFuture(executionContext), (List)new .colon.colon(timeoutContext.timeoutFuture(), (List)Nil$.MODULE$)), executionContext).flatMap((Function1 & Serializable)x0$1 -> {
            ProcessResult processResult = x0$1;
            if (processResult != null) {
                int result = processResult.result();
                Seq<String> stdoutSeq = processResult.stdoutSeq();
                if (result == 0) {
                    return Future$.MODULE$.successful(stdoutSeq);
                }
            }
            if (processResult != null) {
                int result = processResult.result();
                Seq<String> stderrSeq = processResult.stderrSeq();
                String errorOutput = stderrSeq.isEmpty() ? "None" : stderrSeq.mkString("\n");
                MODULE$.logger().error(new StringBuilder(50).append("Command execution failed. Result: ").append(result).append(". Error output: ").append(errorOutput).toString(), logContext);
                return Future$.MODULE$.failed((Throwable)new CommandError(errorOutput));
            }
            throw new MatchError((Object)processResult);
        }, executionContext).andThen((PartialFunction)new Serializable(timeout, commandLog, logContext){
            private static final long serialVersionUID = 0L;
            private final Duration timeout$1;
            private final String commandLog$1;
            private final LogContext logContext$1;

            public final <A1 extends Try<Seq<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Failure failure;
                A1 A1 = x1;
                if (A1 instanceof Failure && (failure = (Failure)A1).exception() instanceof TimeoutException) {
                    CommandRunner$.MODULE$.logger().error(new StringBuilder(45).append("Command execution timed out after ").append(this.timeout$1).append(". Command: ").append(this.commandLog$1).toString(), this.logContext$1);
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Try<Seq<String>> x1) {
                Failure failure;
                Try<Seq<String>> try_ = x1;
                return try_ instanceof Failure && (failure = (Failure)try_).exception() instanceof TimeoutException;
            }
            {
                this.timeout$1 = timeout$1;
                this.commandLog$1 = commandLog$1;
                this.logContext$1 = logContext$1;
            }
        }, executionContext).andThen((PartialFunction)new Serializable(commandExecutionContext){
            private static final long serialVersionUID = 0L;
            private final CommandExecutionContext commandExecutionContext$1;

            public final <A1 extends Try<Seq<String>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof Failure) {
                    this.commandExecutionContext$1.cleanup();
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Try<Seq<String>> x2) {
                Try<Seq<String>> try_ = x2;
                return try_ instanceof Failure;
            }
            {
                this.commandExecutionContext$1 = commandExecutionContext$1;
            }
        }, executionContext).andThen((PartialFunction)new Serializable(timeoutContext, logContext){
            private static final long serialVersionUID = 0L;
            private final TimeoutContext timeoutContext$1;
            private final LogContext logContext$1;

            public final <A1 extends Try<Seq<String>>, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                .colon.colon cmdNamesToCleanup = new .colon.colon((Object)"ssh-add", (List)new .colon.colon((Object)"git", (List)Nil$.MODULE$));
                this.timeoutContext$1.cleanup();
                CommandRunner$.MODULE$.codacy$git$runners$CommandRunner$$cleanupHangingProcesses((scala.collection.immutable.Seq<String>)cmdNamesToCleanup, this.logContext$1);
                return (B1)BoxedUnit.UNIT;
            }

            public final boolean isDefinedAt(Try<Seq<String>> x3) {
                Try<Seq<String>> try_ = x3;
                return true;
            }
            {
                this.timeoutContext$1 = timeoutContext$1;
                this.logContext$1 = logContext$1;
            }
        }, executionContext);
    }

    public void codacy$git$runners$CommandRunner$$cleanupHangingProcesses(scala.collection.immutable.Seq<String> cmdNames, LogContext logContext) {
        this.logger().info(new StringBuilder(41).append("Cleaning up possibly hanging processes (").append(cmdNames.mkString(",")).append(")").toString(), logContext);
        cmdNames.foreach((Function1 & Serializable)cmdName -> BoxesRunTime.boxToInteger((int)CommandRunner$.$anonfun$cleanupHangingProcesses$1(cmdName)));
    }

    public static final /* synthetic */ int $anonfun$cleanupHangingProcesses$1(String cmdName) {
        return Process$.MODULE$.apply((Seq)new .colon.colon((Object)"pkill", (List)new .colon.colon((Object)"-KILL", (List)new .colon.colon((Object)cmdName, (List)Nil$.MODULE$)))).$bang();
    }

    private CommandRunner$() {
    }
}

