/*
 * Decompiled with CFR 0.152.
 */
package codacy.utils;

import codacy.exceptions.DirectoryCreationException;
import codacy.exceptions.DirectoryDeletionException;
import codacy.foundation.logging.context.ContextAwareLogger;
import codacy.foundation.logging.context.ContextLogging;
import codacy.foundation.logging.context.LogContext;
import codacy.foundation.logging.context.ProjectLogContext;
import java.io.File;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import scala.Function0;
import scala.MatchError;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class FileOperations$
implements ContextLogging {
    public static final FileOperations$ MODULE$ = new FileOperations$();
    private static transient ContextAwareLogger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        ContextLogging.$init$((ContextLogging)MODULE$);
    }

    private ContextAwareLogger logger$lzycompute() {
        FileOperations$ fileOperations$ = this;
        synchronized (fileOperations$) {
            if (!bitmap$trans$0) {
                logger = ContextLogging.logger$((ContextLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public ContextAwareLogger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public void createDirectory(File dir, ProjectLogContext logContext) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> FileUtils.forceMkdir((File)dir));
        if (try_ instanceof Success) {
            this.logger().info(new StringBuilder(18).append("Created directory ").append(dir.getAbsolutePath()).toString(), (LogContext)logContext);
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.logger().error(new StringBuilder(27).append("Failed to create directory ").append(dir.getAbsolutePath()).toString(), (LogContext)logContext);
            throw new DirectoryCreationException(dir.getAbsolutePath(), exception.getMessage());
        }
        throw new MatchError((Object)try_);
    }

    public void deleteDirectory(File projectDir, ProjectLogContext logContext) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.logger().info(new StringBuilder(19).append("Deleting directory ").append(projectDir.getAbsolutePath()).toString(), (LogContext)logContext);
            FileUtils.deleteDirectory((File)projectDir);
        });
        if (try_ instanceof Success) {
            this.logger().info(new StringBuilder(18).append("Deleted directory ").append(projectDir.getAbsolutePath()).toString(), (LogContext)logContext);
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.logger().error(new StringBuilder(27).append("Failed to delete directory ").append(projectDir.getAbsolutePath()).toString(), exception, (LogContext)logContext);
            throw new DirectoryDeletionException(projectDir.getAbsolutePath(), exception.getMessage());
        }
        throw new MatchError((Object)try_);
    }

    private FileOperations$() {
    }
}

