**B503: Test for SSL use with bad defaults specified**

This plugin is part of a family of tests that detect the use of known
bad versions of SSL/TLS, please see ../plugins/ssl\_with\_bad\_version
for a complete discussion. Specifically, this plugin test scans for
Python methods with default parameter values that specify the use of
broken SSL/TLS protocol versions. Currently, detection supports methods
using Python's native SSL/TLS support and the pyOpenSSL module. A MEDIUM
severity warning will be reported whenever known broken protocol
versions are detected.

**Config Options:**

This test shares the configuration provided for the standard
../plugins/ssl\_with\_bad\_version test, please refer to its
documentation.

Example

:   

<!-- -->

    >> Issue: Function definition identified with insecure SSL/TLS protocol
    version by default, possible security issue.
       Severity: Medium   Confidence: Medium
       Location: ./examples/ssl-insecure-version.py:28
    27
    28  def open_ssl_socket(version=SSL.SSLv2_METHOD):
    29      pass

See also

-   `ssl_with_bad_version()`{.xref .py .py-func .docutils .literal
    .notranslate}

-   `ssl_with_no_version()`{.xref .py .py-func .docutils .literal
    .notranslate}

-   <http://heartbleed.com/>

-   <https://poodlebleed.com/>

-   <https://security.openstack.org/>

-   <https://security.openstack.org/guidelines/dg_move-data-securely.html>

New in version 0.9.0.
