**B504: Test for SSL use with no version specified**

This plugin is part of a family of tests that detect the use of known
bad versions of SSL/TLS, please see ../plugins/ssl\_with\_bad\_version
for a complete discussion. Specifically, This plugin test scans for
specific methods in Python's native SSL/TLS support and the pyOpenSSL
module that configure the version of SSL/TLS protocol to use. These
methods are known to provide default value that maximize compatibility,
but permit use of the aforementioned broken protocol versions. A LOW
severity warning will be reported whenever this is detected.

**Config Options:**

This test shares the configuration provided for the standard
../plugins/ssl\_with\_bad\_version test, please refer to its
documentation.

Example

:   

<!-- -->

    >> Issue: ssl.wrap_socket call with no SSL/TLS protocol version
    specified, the default SSLv23 could be insecure, possible security
    issue.
       Severity: Low   Confidence: Medium
       Location: ./examples/ssl-insecure-version.py:23
    22
    23  ssl.wrap_socket()
    24

See also

-   `ssl_with_bad_version()`{.xref .py .py-func .docutils .literal
    .notranslate}

-   `ssl_with_bad_defaults()`{.xref .py .py-func .docutils .literal
    .notranslate}

-   <http://heartbleed.com/>

-   <https://poodlebleed.com/>

-   <https://security.openstack.org/>

-   <https://security.openstack.org/guidelines/dg_move-data-securely.html>

New in version 0.9.0.
