The box model is one of the most frequently misunderstood parts of CSS.
"Box model" refers to the series of boxes that make up an element visually.
This starts with the content, which is the inner-most box.
Content is surrounded by padding, which in turn is surrounded by borders.
The way these measurements interact, however, is a bit confusing. Consider the following:

     .mybox {
       border: 1px solid black;
       padding: 5px;
       width: 100px;
     }

A new developer might assume that the width of an element with the mybox class would be 100 pixels.
In fact, the width is 112 pixels because width refers to the content box and padding and borders are added on top of that.
Frequently when developers include this combination of properties, it is an error because they are expecting different behavior.

You can force most browsers to obey width and height as the full size of an element by using the box-sizing property
and setting it to border-box, as in this example:

     .mybox {
       box-sizing: border-box;
       border: 1px solid black;
       padding: 5px;
       width: 100px;
     }

Now an element with a class of mybox will have an actual width of 100 pixels, and the padding
and borders will exist inside of that area, leaving 88 pixels for content instead of 100 pixels.

[Source](https://github.com/CSSLint/csslint/wiki/Beware-of-box-model-size)
      