The float property is the most popular method of achieving columnar layouts using CSS.
During the course of a project, more and more float elements are used to create ever-different layouts throughout a page or site.
This leads to fragile CSS that is easy to break if one aspect of the layout changes.

Frequently, using too many floats is a sign that your project would benefit from a grid system. CSS grid systems standardize columnar layouts using CSS classes. Some popular grid systems are:

+ [960gs](http://960.gs/)
+ [Blueprint](http://blueprintcss.org/)
+ [OOCSS Grids](http://github.com/stubbornella/oocss/)
+ [YUI Grids](http://yuilibrary.com/yui/docs/cssgrids/)

Using one of these grid systems can greatly reduce the amount of CSS code you need to write by hand.

[Source](https://github.com/CSSLint/csslint/wiki/Disallow-too-many-floats)
      