---
pageClass: rule-details
sidebarDepth: 0
title: vue/comma-dangle
description: require or disallow trailing commas
---
# vue/comma-dangle
> require or disallow trailing commas

- :wrench: The `--fix` option on the [command line](https://eslint.org/docs/user-guide/command-line-interface#fixing-problems) can automatically fix some of the problems reported by this rule.

This rule is the same rule as core [comma-dangle] rule but it applies to the expressions in `<template>`.

## :books: Further reading

- [comma-dangle]

[comma-dangle]: https://eslint.org/docs/rules/comma-dangle

## :mag: Implementation

- [Rule source](https://github.com/vuejs/eslint-plugin-vue/blob/master/lib/rules/comma-dangle.js)
- [Test source](https://github.com/vuejs/eslint-plugin-vue/blob/master/tests/lib/rules/comma-dangle.js)
