## Using latest is prone to errors if the image will ever update. Pin the version explicitly to a release tag.

### Problematic code:

```dockerfile
FROM debian:latest
```

### Correct code:

```dockerfile
FROM debian:jessie
```
### Rationale:

You can never rely that the `latest` tags is a specific version.

https://docs.docker.com/engine/userguide/dockerimages/

> Tip: You recommend you always use a specific tagged image, for example ubuntu:12.04. That way you always know exactly what variant of an image is being used.