## Avoid additional packages by specifying --no-install-recommends.

### Problematic code:

```dockerfile
FROM busybox
RUN apt-get install -y python=2.7
```

### Correct code:

```dockerfile
FROM busybox
RUN apt-get install -y --no-install-recommends python=2.7
```

### Rationale:

Avoid installing additional packages that you did not explicitly want.