## COPY --from should reference a previously defined FROM alias

### Problematic code:

```dockerfile
FROM debian:jesse

RUN stuff

FROM debian:jesse

COPY --from=build some stuff ./
```

### Correct code:

```dockerfile
FROM debian:jesse as build

RUN stuff

FROM debian:jesse

COPY --from=build some stuff ./
```
### Rationale:

Trying to copy from a missing image alias results in an error.