## Use SHELL to change the default shell

### Problematic code:

```dockerfile
# Install bash
RUN apk add --update-cache bash=4.3.42-r3

# Use bash as the default shell
RUN ln -sfv /bin/bash /bin/sh
```

### Correct code:

```dockerfile
# Install bash
RUN apk add --update-cache bash=4.3.42-r3

# Use bash as the default shell
SHELL ["/bin/bash", "-c"]
```
### Rationale:

Docker provides a [`SHELL` instruction](https://docs.docker.com/engine/reference/builder/#/shell) which does not require overwriting `/bin/sh` in your container.
