## Don't use $ on the left side of assignments.

### Problematic code:

```sh
$greeting="Hello World"
```

### Correct code:

```sh
greeting="Hello World"
```

Alternatively, if the goal was to assign to a variable whose name is in another variable (indirection), use `declare`:

```sh
name=foo
declare "$name=hello world"
echo "$foo"
```

### Rationale:

Unlike Perl or PHP, `$` is not used when assigning to a variable.

### Exceptions

None
