## "Use braces when expanding arrays, e.g. ${array[idx]} (or ${var}[.. to quiet)."

### Problematic code:

```sh
echo "$array[@]"
```

### Correct code:

```sh
echo "${array[@]}"
```

### Rationale:

Some languages use the syntax `$array[index]` to access an index of an arrays, but a shell will interpret this as `$array` followed by the unrelated literal string (or glob) `[index]`.

Curly braces are needed to tell the shell that the square brackets are part of the expansion.

### Exceptions

If you want the square brackets to be treated literally or as a glob, use `${var}[idx]` to prevent this warning.

This does not change how the script works, but clarifies your intent to ShellCheck as well as other programmers.