## Quote/escape special characters when using eval, e.g. eval "a=(b)".

### Problematic code:

```sh
eval $var=(a b)
```

### Correct code:

```sh
eval "$var=(a b)"
```

### Rationale:

Shells differ widely in how they handle unescaped parentheses in `eval` expressions.

* `eval foo=bar` is allowed by dash, bash and ksh.
* `eval foo=(bar)` is allowed by bash and ksh, but not dash.
* `eval $var=(bar)` is allowed by ksh, but not bash or dash.
* `eval foo() ( echo bar; )` is not allowed by any shell.

Since the expression is evaluated as shell script code anyways, it should be passed in as a literal string without relying on special case parsing rules in the target shell. Quote/escape the characters accordingly.

### Exceptions:

None.
