XML External Entity (XXE) attacks can occur when an XML parser supports XML entities while processing XML received from an untrusted source.

Vulnerable Code:

    SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
    parser.parse(inputStream, customHandler);

Solution using "Secure processing" mode:

    SAXParserFactory spf = SAXParserFactory.newInstance();
    spf.setFeature(XMLConstants.FEATURE_SECURE_PROCESSING, true);
    SAXParser parser = spf.newSAXParser();
    parser.parse(inputStream, customHandler);

Solution disabling DTD:

    SAXParserFactory spf = SAXParserFactory.newInstance();
    spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
    SAXParser parser = spf.newSAXParser();
    parser.parse(inputStream, customHandler);

[More info](http://h3xstream.github.io/find-sec-bugs/bugs.htm#XXE_SAXPARSER)
