//#Patterns: Custom_Scala_InsecureCookie
import play.api.mvc._

class Test {

  //default args (positive)
  //#Err: Custom_Scala_InsecureCookie
  Cookie("name","value")
  //full arg list positive
  //#Err: Custom_Scala_InsecureCookie
  Cookie("name","value",Some(77),"path",Some("domain"),false,false)
  //full arg list negative
  Cookie("name","value",Some(77),"path",Some("domain"),true,false)


  //named arg positive
  //#Err: Custom_Scala_InsecureCookie
  Cookie("name","value",secure = false)
  //#Err: Custom_Scala_InsecureCookie
  Cookie("name","value",secure = false, domain = Some("domain"))

  //named arg negative
  Cookie("name","value",secure = true)
  Cookie("name","value",secure = true, domain = Some("domain"))

  //constr
  //default args (positive)
  //#Err: Custom_Scala_InsecureCookie
  new Cookie("name","value")
  //#Err: Custom_Scala_InsecureCookie
  Cookie("name","value",Some(77),"path",Some("domain"),httpOnly = false)

  //full arg list positive
  //#Err: Custom_Scala_InsecureCookie
  new Cookie("name","value",Some(77),"path",Some("domain"),false,false)
  //full arg list negative
  new Cookie("name","value",Some(77),"path",Some("domain"),true,false)

  //all but last arg positive
  //#Err: Custom_Scala_InsecureCookie
  Cookie("name","value",Some(77),"path",Some("domain"),false)
  //all but last arg negative
  Cookie("name","value",Some(77),"path",Some("domain"),true)
  
  //named arg positive
  //#Err: Custom_Scala_InsecureCookie
  new Cookie("name","value",secure = false)
  //#Err: Custom_Scala_InsecureCookie
  new Cookie("name","value",secure = false, domain = Some("domain"))

  //named arg negative
  new Cookie("name","value",secure = true)
  new Cookie("name","value",secure = true, domain = Some("domain"))

  //full path
  //#Err: Custom_Scala_InsecureCookie
  play.api.mvc.Cookie("name","value",secure = false, domain = Some("domain"))
  //#Err: Custom_Scala_InsecureCookie
  new play.api.mvc.Cookie("name","value",secure = false, domain = Some("domain"))

}