package docs.tests

//#Patterns: Custom_Scala_SprayUnvalidatedRedirect
import akka.actor.{ Actor, ActorSystem, Props }
import akka.io.IO
import akka.pattern.ask
import akka.util.Timeout

import spray.http.HttpHeaders.`Content-Type`
import spray.can.Http
import spray.http.HttpHeaders.Host
import spray.routing._
import spray.http._
import org.json4s._
import org.json4s.jackson.Serialization.formats
import spray.httpx.Json4sJacksonSupport

import scala.concurrent.duration._

import scala.concurrent.duration._

object WebServer extends App {

  implicit val system = ActorSystem("spray-example")

  val service = system.actorOf(Props[DemoServiceActor], "demo-service")

  implicit val timeout = Timeout(5.seconds)

  IO(Http) ? Http.Bind(service, interface = "localhost", port = 8080)
}

class DemoServiceActor extends Actor with DemoService {
  def actorRefFactory = context
  def receive = runRoute(route)
}

object Support extends Json4sJacksonSupport {
  implicit val json4sJacksonFormats = formats(NoTypeHints)
}

trait DemoService extends HttpService {
  import Support._

  val route =
    parameters('redirectUrl) { redirectUrl =>
    //#Warn: Custom_Scala_SprayUnvalidatedRedirect
      redirect(redirectUrl, StatusCodes.Redirection)
    } ~
    parameters('bla2, 'redirectUrl2) { (bla2, redirectUrl2) =>
    //#Warn: Custom_Scala_SprayUnvalidatedRedirect
      redirect(redirectUrl2, StatusCodes.Redirection)
    } ~
    //This is ok
    parameters('redirectUrl3, 'bla3) { (redirectUrl3, bla3) =>
      redirect("google.com", StatusCodes.Redirection)
    } ~

    //This is ok
    cookie("redirectUrl4") { redirectUrlCookie4 =>
      redirect("google.com", StatusCodes.Redirection)
    } ~

    cookie("redirectUrl4") { redirectUrlCookie4 =>
    //#Warn: Custom_Scala_SprayUnvalidatedRedirect
      redirect(redirectUrlCookie4.content, StatusCodes.Redirection)
    } ~

      //Should we also check optional cookies? .get? .map? .fold? ever
    optionalCookie("redirectUrl") { redirectUrlCookieOpt =>
      redirectUrlCookieOpt.fold(redirect("google.com", StatusCodes.Redirection)) {
        stillUnsafeRedirect =>
          redirect(redirectUrlCookieOpt.get.content, StatusCodes.Redirection)
      }
    } ~
    headerValue {
      case ct: `Content-Type` => Some(ct)
      case _ => None
    } ( h => complete(h) ) ~
      headerValue {
        case `Content-Type`(ct) => Some(ct)
        case _ => None
      } ( ct => complete(ct) ) ~
      headerValueByType[HttpHeaders.`Content-Type`]() { ct =>
        complete(ct.contentType)
      } ~
      headerValueByType[ContentType]() { ct =>
        complete(ct)
      } ~
      headerValueByName("Content-Type") { ct =>
        complete(ct)
      } ~
      headerValuePF({
        case ct: `Content-Type` => ct
      })( ct => complete(ct)  ) ~
      optionalHeaderValue{
        case ct: `Content-Type`=> Some(ct.contentType)
        case x => None
      }( ct => complete(ct) ) ~
      optionalHeaderValueByType[ContentType]() { ct =>
        complete(ct)
      } ~
      optionalHeaderValueByName("Content-Type") { ct =>
        complete(ct)
      } ~
      optionalHeaderValuePF({
        case h: `Content-Type`=> h
      })( complete(_)  )

}