## This backslash+linefeed is literal. Break outside single quotes if you just want to break the line.

### Problematic code:

```sh
var='This is long \
piece of text'
```

### Correct code:

```sh
var='This is a long '\
'piece of text'
```
### Rationale:

You have a single quoted string containing a backslash followed by a linefeed (newline). Unlike double quotes or unquoted strings, this has no special meaning. The string will contain a literal backslash and a linefeed.

If you wanted to break the line but not add a linefeed to the string, stop the single quote, break the line, and reopen it. This is demonstrated in the correct code.

If you wanted to break the line and also include the linefeed as a literal, you don't need a backslash:

```
var='This is a multi-line string
with an embedded linefeed'
```


### Exceptions:

If you do want a string containing a literal backslash+linefeed combo, such as with `sed`, you can [[ignore]] this warning.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1004)

