## This apostrophe terminated the single quoted string!

### Problematic code:

```sh
echo 'Nothing so needs reforming as other people's habits.'
```

### Correct code:

```sh
echo 'Nothing so needs reforming as other people'\''s habits.'
```
or
```sh
echo "Nothing so needs reforming as other people's habits."
```
### Rationale:

When writing a string in single quotes, you have to make sure that any apostrophes in the text don't accidentally terminate the single quoted string prematurely.

Escape them properly (see the correct code) or switch quotes to avoid the problem.

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1011)

