## Use 'if cmd; then ..' to check exit code, or 'if [ "$(cmd)" = .. ]' to check output.

### Problematic code:

```sh
if [ grep -q pattern file ]
then
  echo "Found a match"
fi
```

### Correct code:

```sh
if grep -q pattern file
then
  echo "Found a match"
fi

```
### Rationale:

`[ .. ]` is not part of shell syntax like `if` statements. It is not equivalent to parentheses in C-like languages, `if (foo) { bar; }`, and should not be wrapped around commands to test. 

`[` is just regular command, like `whoami` or `grep`, but with a funny name (see `ls -l /bin/[`). It's a shorthand for `test`. 

If you want to check the exit status of a certain command, use that command directly as demonstrated in the correct code.

If you want to check the output of a command, use `"$(..)"` to get its output, and then use `test` or  `[`/`[[` to do a string comparison:

```
# Check output of `whoami` against the string `root`
if [ "$(whoami)" = "root" ]
then
  echo "Running as root"
fi
```

For more information, see [this problem in the Bash Pitfall](http://mywiki.wooledge.org/BashPitfalls#if_.5Bgrep_foo_myfile.5D) list, or generally [Tests and Conditionals](http://mywiki.wooledge.org/BashGuide/TestsAndConditionals) in the WoolEdge BashGuide 

### Exceptions:

None.

### Related resources:

* [How do I use a file grep comparison inside a bash if/else statement?](https://stackoverflow.com/questions/2480584/how-do-i-use-a-file-grep-comparison-inside-a-bash-if-else-statement)
* Bash Pitfalls: [ if [grep foo myfile] ](https://mywiki.wooledge.org/BashPitfalls#if_.5Bgrep_foo_myfile.5D)
[Source](https://github.com/koalaman/shellcheck/wiki/SC1014)

