## Literal carriage return. Run script through `tr -d '\r'` .

### Problematic code:

```sh
$ cat -v myscript
#!/bin/sh^M
echo "Hello World"^M
```

### Correct code:

```sh
$ cat -v myscript
#!/bin/sh
echo "Hello World"
```
### Rationale:

The script uses Windows/DOS style `\r\n` line terminators instead of UNIX style `\n` terminators. The additional `\r` aka `^M` aka carriage return characters will be treated literally, and results in all sorts strange bugs and messages.

You can verify this with `cat -v yourfile` and see whether or not each line ends with a `^M`. To delete them, open the file in your editor and save the file as "Unix", "UNIX/OSX Format", `:set ff=unix` or similar if it supports it.

If you don't know how to get your editor to save a file with Unix line terminators, you can use `tr`:

    tr -d '\r' < badscript   > goodscript

This will read a script `badscript` with possible carriage returns, and write `goodscript` without them.

### Exceptions:

None

### Related resources:

* [BashFaq: How do I convert a file from DOS format to UNIX format (remove CRs from CR-LF line terminators)?](https://mywiki.wooledge.org/BashFAQ/052)
* [StackOverflow: Are shell scripts sensitive to encoding and line endings?
](https://stackoverflow.com/questions/39527571/are-shell-scripts-sensitive-to-encoding-and-line-endings)
[Source](https://github.com/koalaman/shellcheck/wiki/SC1017)

