## You need a space before the if single then "]" else "]]"

### Problematic code:

```
if [ "$STUFF" = ""]; then
```

### Correct code:

```
if [ "$STUFF" = "" ]; then
```

### Rationale:
Bourne shells are very whitespace sensitive. Adding or removing spaces can drastically alter the meaning of a script. In these cases, ShellCheck has noticed that you're missing a space at the position indicated.

### Exceptions
none.

### Ignore
```
# shellcheck disable=SC1020
if [ "$STUFF" = ""]; then
...
```
[Source](https://github.com/koalaman/shellcheck/wiki/SC1020)

