## Expected 'then'.

### Problematic code:

```sh
if true
  echo "True"
fi
```

### Correct code:

```sh
if true
then
  echo "True"
fi
```
### Rationale:

ShellCheck has found an `if` statement that appears to be missing a `then`.

Make sure the `then` exists, and that it is the first word of the line (or immediately preceded by a semicolon).

### Exceptions:

None
[Source](https://github.com/koalaman/shellcheck/wiki/SC1050)

