## You need a space after the '{'.

### Problematic code:

```sh
foo() {echo "hello world;}
```

### Correct code:

```sh
foo() { echo "hello world;}
```
### Rationale:

`{` is only recognized as the start of a command group when it's a separate token.

If it's not a separate token, like in the problematic example, it will be considered a literal character, as if writing `"{echo"` with quotes, and therefore usually cause a syntax error.

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1054)

