## Expected `do`.

### Problematic code:

```sh
for file in *
  echo "$file"
done
```

### Correct code:

```sh
for file in *
do
  echo "$file"
done
```
### Rationale:

ShellCheck has found a loop that appears to be missing a `do` statement. In the problematic code, it was simply forgotten.

Verify that the `do` exists, and that it's in the correct place.

### Exceptions:

None
[Source](https://github.com/koalaman/shellcheck/wiki/SC1058)

