## Scripts are case sensitive. Use 'if', not 'If'.

### Problematic code:

```sh
If true
Then
  echo "hello"
Fi
```

### Correct code:

```sh
if true
then
  echo "hello"
fi
```

### Rationale:

Shells are case sensitive and do not accept `If` or `IF` in place of lowercase `if`.

### Exceptions

If you're aware of this and insist on naming a function `WHILE`, you can quote the name to prevent shellcheck from thinking you meant `while`. Or if you really want the names, add things like `alias If=if IF=if` to replace those keywords and ask shellcheck to ignore them.

[Source](https://github.com/koalaman/shellcheck/wiki/SC1081)

