## Parsing stopped here. Is this keyword correctly matched up?

### Problematic code:

```sh
if true
then
  echo hello
fi
fi
```

### Correct code:

```sh
if true
then
  echo hello
fi
```

### Rationale:

This error is typically seen when there are too many `fi`, `done` or `esac`s, or when there's a `do` or `then` without a corresponding `while`, `for` or `if`. This is often due to deleting a loop or conditional statement but not its terminator.

In some cases, it can even be caused by bad quoting:

```sh
var="foo
if [[ $var = "bar ]
then
  echo true
fi
```

In this case, the `if` ends up inside the double quotes, leaving the `then` dangling.

### Exceptions:

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC1089)

