## Remove spaces between # and ! in the shebang.

### Problematic code:

```sh
# !/bin/sh
echo "Hello World"
```

### Correct code:

```sh
#!/bin/sh
echo "Hello World"
```
### Rationale:

The script has spaces between the `#` and `!` in the shebang. This is not valid.

Remove the spaces so the OS can correctly recognize the file as a script.

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1115)

