## Missing $ on a $((..)) expression? (or use ( ( for arrays).

### Problematic code:

```sh
var=((foo+1))
```

### Correct code:

```sh
var=$((foo+1))
```

### Rationale:

You appear to be missing the `$` on an assignment from an arithmetic expression `var=$((..))` .

Without the `$`, this is an array expression which is either nested (ksh) or invalid (bash). 

### Exceptions:

If you are trying to define a multidimensional Ksh array, add spaces between the `( (` to clarify:

    var=( (1 2 3) (4 5 6) )

[Source](https://github.com/koalaman/shellcheck/wiki/SC1116)

