## Delete whitespace after the here-doc end token.

### Problematic code:

"▭" below indicates an otherwise invisible space:

```sh
cat << "eof"
Hello
eof▭   
```

### Correct code:

```sh
cat << "eof"
Hello
eof
```
### Rationale:

The end token of your here document has trailing whitespace. This is invisible to the naked eye, but shells do not accept it.

Remove the trailing whitespace.

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1118)

