## The shebang must be on the first line. Delete blanks and move comments.

### Problematic code:

```sh
# Copyright 2018 Foobar, All rights reserved
#!/bin/bash
```

### Correct code:

```sh
#!/bin/bash
# Copyright 2018 Foobar, All rights reserved
```

### Rationale:

A shebang only has an effect when it appears as the first line in a script. Specifically, the first two bytes of the file must be `#!`.

Adding comments, copyright notices or simply an accidental blank line before it will turn a shebang into an ineffectual comment. This means that the script is no longer in charge of its own interpreter, and may fail to run or produce different results depending on the context it's run (e.g. it may work from `bash` but not from `zsh` or via `sudo`).

Delete any leading blank lines, and move all comments after the shebang.

### Exceptions:

None

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC1128)

