# Use `$(...)` notation instead of legacy backticked `` `...` ``.

### Problematic code

```sh
echo "You are running on `uname`"
```

### Correct code

```sh
echo "You are running on $(uname)"
```

### Rationale

Backtick command substitution `` `...` `` is legacy syntax with several issues.

1. It has a series of undefined behaviors related to quoting in POSIX.
1. It imposes a custom escaping mode with surprising results.
1. It's exceptionally hard to nest.

`$(...)` command substitution has none of these problems, and is therefore strongly encouraged.

### Exceptions

None.

### Related resources:

* [BashFaq: Why is `$(...)` preferred over `` `...` `` (backticks)?](http://mywiki.wooledge.org/BashFAQ/082)
* [StackOverflow: What is the difference between $(command) and `` `command` `` in shell programming?](https://stackoverflow.com/questions/4708549/shell-programming-whats-the-difference-between-command-and-command)

[Source](https://github.com/koalaman/shellcheck/wiki/SC2006)

