# Use $((..)) instead of deprecated $[..]

### Problematic code

```sh
n=1
n=$[n+1]
```

### Correct code

```sh
n=1
n=$((n+1))
```

### Rationale

The `$[..]` syntax was deprecated in Bash 2.0 and replaced with the standard `$((..))` syntax from Korn shell

### Exceptions

None.

### See also

- http://unix.stackexchange.com/questions/209833/what-does-a-dollar-sign-followed-by-a-square-bracket-mean-in-bash
[Source](https://github.com/koalaman/shellcheck/wiki/SC2007)

