## Don't use [] around ranges in tr, it replaces literal square brackets.

### Problematic code:

```sh
tr -cd '[a-z]'
```

### Correct code:

```sh
tr -cd 'a-z'
```
### Rationale:

Ancient System V `tr` required brackets around operands, but modern implementations including POSIX, GNU, OS X and *BSD instead treat them as literals.

Unless you want to operate on literal square brackets, don't include them.

### Exceptions:

If you do want to replace literal square brackets, reorder the expression (e.g. `a-z[]` to make it clear that the brackets are not special).

ShellCheck does not warn about correct usage of `[..]` in character and equivalence classes like `[:lower:]` and `[=e=]`.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2021)

