## Use spaces, not commas, to separate array elements.

### Problematic code:

```sh
flags=("-l", "-d", "--sort=size")
ls "${flags[@]}"
```

### Correct code:

```sh
flags=("-l" "-d" "--sort=size")
ls "${flags[@]}"
```
### Rationale:

You appear to have used commas to separate array elements in an array assignment. Other languages require this, but bash instead treats the commas as literal strings.

In the problematic code, the first element is `-l,` with the trailing comma, and the executed command ends up being `ls -l, -d, --sort=size`.

In the correct code, the trailing commas have been removed, and the command will be `ls -l -d --sort=size` as expected.

### Exceptions:

None (if you actually want a trailing comma in your strings, move them inside the quotes).
[Source](https://github.com/koalaman/shellcheck/wiki/SC2054)

