# Quote the grep pattern so the shell won't interpret it.

### Problematic code
    grep foo* file

### Correct code
    grep "foo*" file

### Rationale
The regex passed to grep frequently contains characters that collide with globs. The code above is supposed to match "f followed by 1 or more o's", but if the directory contains a file called "foo.txt", an unquoted pattern will cause it to become `grep foo.txt file`.

To prevent this, always quote the regex passed to grep, especially when it contains one or more glob character.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2062)

