## Use single quotes, otherwise this expands now rather than when signalled.

### Problematic code:

```sh
trap "echo \"Finished on $(date)\"" EXIT
```

### Correct code:

```sh
trap 'echo "Finished on $(date)"' EXIT
```

### Rationale:

With double quotes, all parameter and command expansions will expand when the trap is defined rather than when it's executed.

In the example, the message will contain the date on which the trap was declared, and not the date on which the script exits.

Using single quotes will prevent expansion at declaration time, and save it for execution time.

### Exceptions

If you don't care that the trap code is expanded early because the commands/variables won't change during execution of the script, or because you want to use the current and not the future values, then you can ignore this message.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2064)

