## `-n` doesn't work with unquoted arguments. Quote or use ``[[ ]]``.

### Problematic code:

```sh
if [ -n $var ]
then
  echo "var has a value"
else
  echo "var is empty"
fi
```

### Correct code:

In POSIX:

```sh
if [ -n "$var" ]
then
  echo "var has a value"
else
  echo "var is empty"
fi
```

In bash/ksh:

```sh
if [[ -n $var ]]
then
  echo "var has a value"
else
  echo "var is empty"
fi
```


### Rationale:

When `$var` is unquoted, a blank value will cause it to wordsplit and disappear. If `$var` is empty, these two statements are identical:

```sh
[ -n $var ]
[ -n ]
```

`[ string ]` is shorthand for testing if a string is empty. This is still true if `string` happens to be `-n`. `[ -n ]` is therefore true, and by extension so is `[ -n $var ]`.

To fix this, either quote the variable, or (if your shell supports it) use `[[ -n $var ]]` which generally has fewer caveats than `[`.

### Exceptions:

None

[Source](https://github.com/koalaman/shellcheck/wiki/SC2070)

