## Quote 'EOF' to make here document expansions happen on the server side rather than on the client.

### Problematic code:

```sh
ssh host.example.com << EOF
  echo "Logged in on $HOSTNAME"
EOF
```

### Correct code:

```sh
ssh host.example.com << "EOF"
  echo "Logged in on $HOSTNAME"
EOF
```

### Rationale:

When the end token of a here document is unquoted, parameter expansion and command substitution will happen on in contents of the here doc.

This means that before sending the commands to the server, the client replaces `$HOSTNAME` with localhost, thereby sending `echo "Logged in on localhost"` to the server. This has the effect of printing the client's hostname instead of the server's.

Scripts with any kind of variable use are especially problematic because all references will be expanded before the script run. For example,

```sh
ssh host << EOF
  x="$(uname -a)"
  echo "$x"
EOF
```

will never print anything, neither client nor server details, since before evaluation, it will be expanded to:

```sh
  x="Linux localhost ... x86_64 GNU/Linux"
  echo ""
```

By quoting the here token, local expansion will not take place, so the server sees `echo "Logged in on $HOSTNAME"` which is expanded and printed with the server's hostname, which is usually the intention.

### Exceptions:

If the client should expand some or all variables, this message can and should be ignored.

To expand a mix of local and remote variables, the here doc end token should be unquoted, and the remote variables should be escaped, e.g.

```sh
ssh host.example.com << EOF
  echo "Logged in on \$HOSTNAME from $HOSTNAME"
EOF
```

[Source](https://github.com/koalaman/shellcheck/wiki/SC2087)

