## Use `$((..))` for arithmetics, e.g. `i=$((i + 2))`

### Problematic code:

```sh
i=3
i=i + 2
```

### Correct code:

```sh
i=3
i=$((i + 2))
```

### Rationale:

Unlike most languages, variable assignments in shell scripts are space sensitive and (almost) always assign strings.

To evaluate a mathematical expressions, use `$((..))` as in the correct code:

    i=$((i + 2))   # Spaces are fine inside $((...))

In the problematic code, `i=i + 2` will give an error `+: command not found` because the expression is interpreted similar to something like `LC_ALL=C wc -c` instead of numerical addition:
 
     Prefix assignment    Command  Argument
     LC_ALL=C             wc       -c
     i=i                  +        2

### Exceptions:

If you wanted to assign a literal string, quote it:

    game_score="0 - 2"

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC2099)

