# Named class needs outer [], e.g. [[:digit:]\].

### Problematic code:

```sh
gzip file[:digit:]*.txt
```

### Correct code:

```sh
gzip file[[:digit:]]*.txt
```

### Rationale:

Predefined character groups are supposed to be used inside character ranges. `[:digit:]` matches one of "digt:" just like `[abc]` matches one of "abc". `[[:digit:]]` matches a digit.

### Exceptions

When passing an argument to `tr` which parses these by itself without relying on globbing, you should quote it instead, e.g. `tr -d '[:digit:]'`

[Source](https://github.com/koalaman/shellcheck/wiki/SC2101)

