## In [\[..]], use && instead of -a.

### Problematic code:

```sh
[[ "$1" = "-v" -a -z "$2" ]]
```

### Correct code:

```sh
[[ "$1" = "-v" && -z "$2" ]]
```

### Rationale:

`-a` for logical AND is not supported in a `[[ .. ]]` expression. Use `&&` instead.

### Exceptions:

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2108)

