## In [\[..]], use || instead of -o.

### Problematic code:

```sh
[[ "$1" = "-v" -o "$1" = "-help" ]]
```

### Correct code:

```sh
[[ "$1" = "-v" || "$1" = "-help" ]]
```

### Rationale:

`-o` for logical OR is not supported in a `[[ .. ]]` expression. Use `||` instead.

### Exceptions:

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2110)

