## Warning: deletes a system directory. 

### Problematic code:

```sh
rm -rf /usr /lib/nvidia-current/xorg/xorg
```

### Correct code:

```sh
rm -rf /usr/lib/nvidia-current/xorg/xorg
```

### Rationale:

The example line of code was an actual bug in the [Bumblebee NVIDIA driver](https://github.com/MrMEEE/bumblebee-Old-and-abbandoned/commit/a047be85247755cdbe0acce6f1dafc8beb84f2ac).

Due to an accidental space, it deleted `/usr` instead of just the particular directory.

### Exceptions:

If you do intend to delete a system directory, such as when working in a chroot or initramfs, you can disable this message with a directive: 

```sh
# shellcheck disable=SC2114
rm -rf /usr 
```

Previous versions of shellcheck, up to and including 0.4.6, would ignore `rm` statements containing a `--` (an arbitrary convention). This is no longer the case.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2114)

