## To run commands as another user, use su -c or sudo.

### Problematic code:

```sh
whoami
su
whoami
```

### Correct code:

```sh
whoami
sudo whoami
```

### Rationale:

It's commonly believed that `su` makes a session run as another user. In reality, it starts an entirely new shell, independent of the one currently running your script.

`su; whoami` will start a root shell and wait for it to exit before running `whoami`. It will not start a root shell and then proceed to run `whoami` in it.

To run commands as another user, use `sudo some command` or `su -c 'some command'`. `sudo` is preferred when available, as it doesn't require additional quoting and can be configured to run passwordless if desired.


### Exceptions

If you're aware of the above and want to e.g. start an interactive shell for a user, feel free to ignore this message.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2117)

